<?php namespace App\Models;

use DB;
use stdClass;
use App\Models;

class SystemMsg extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsystem_msg';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xsystem_msgid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult($query = null)
    {
        $instance = new static();

        $query = @$query ? $query : new stdClass();
        $query->where = @$query->where ? $query->where : 1;
        $query->order = (@$query->order and @$query->order != 'NULL') ? $query->order : "{$instance->primaryKey}";
        $query->having = @$query->having ? $query->having : 1;

        $res = DB::table($instance->table)
            ->whereRaw($query->where)
            ->orderBy($query->order)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    /**
     * get First
     * @param $id
     * @return mixed
     */
    public static function first($id)
    {
        $instance = new static();

        $res = self::getResult()
            ->where($instance->primaryKey, $id)
            ->first();
        return $res;
    }

    /**
     * Get Mobile Numbers
     * @param $id
     * @return mixed
     */
    public static function getEmail($smsid)
    {
        $res = DB::table('xxsubscribe');
        return $res;
    }

    /**
     * Insert Mobile Numbers
     * @param $id
     * @return mixed
     */
    /**
     * update or insert
     * @param $data
     * @param int $id
     * @return int
     */
    public static function store($data, $id = 0)
    {
        $instance = new static();
        if (!$id)
            $id = $instance->newQuery()->insertGetId($data);
        else
            $instance->newQuery()->where($instance->primaryKey, intval($id))->update($data);

        return $id;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();
        $q = new stdClass();
        $q->where = is_object($id) ? $id->where : ($instance->primaryKey . " = " . intval($id));

        $res = $instance->newQuery()->whereRaw($q->where)->delete();
        return $res;
    }
}