<?php namespace App\Models;

use App;
use App\Models\Builder as QueryBuilder;
use DB;
use File;
use Illuminate\Database\Eloquent\Model as BaseModel;

class Model extends BaseModel {

    /**
     * The primary key for the model.
     *
     * @var string
     */
    public $lang = true;

    /**
     * Create a new Eloquent model instance.
     *
     * @param  array  $attributes
     * @return void
     */
    public function __construct(array $attributes = array()) {
        // DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);

        parent::__construct($attributes);
    }

    /**
     * Create a new Eloquent query builder for the model.
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder|static
     */
    public function newEloquentBuilder($query) {
        return new CustomEloquentBuilder($query);
    }

    protected function newBaseQueryBuilder() {
        $conn = $this->getConnection();
        $grammar = $conn->getQueryGrammar();
        return new QueryBuilder($conn, $grammar, $conn->getPostProcessor());
    }

    public function getCasts() {
        return $this->casts;
    }

    public function getRelations() {
        return $this->relation;
    }

    /**
     * get Sql and set bindings
     * @return $sql
     */
    public static function getSql() {
        $instance = new static();
        $builder = $instance->getBuilder();
        $sql = $builder->toSql();

        foreach ($builder->getBindings() as $binding) {
            $value = is_numeric($binding) ? $binding : "'" . $binding . "'";
            $sql = preg_replace('/\?/', $value, $sql, 1);
        }

        return $sql;
    }

    /**
     * fetch Enum
     * @param $table
     * @param $column
     * @return array
     */
    public static function fetchEnum($column, $table = '') {
        $instance = new static();
        //DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);
        $table = ($table ? $table : $instance->getTable());
        $res = array();

        $sql = "SHOW COLUMNS FROM $table LIKE '$column'";
        $result = DB::select(DB::Raw($sql), array());

        if (count($result) > 0) {
            $result = $result[0];
            $type = @$result['type'] ? $result['type'] : $result['Type'];
            preg_match_all("/'(.*?)'/", $type, $matches);
            if (@$matches[1]) {
                foreach ($matches[1] as $key => $val) {
                    $res[$val] = $val;
                }
            }
        }
        return $res;
    }

    public static function arrayToSqlTable($array){
        $sql = '';
        $i =0;
        foreach ($array as $key => $value) {
            if($i==0){
                $sql = " SELECT " . $key . " AS id, '" . $value . "' AS name ";
            }else{
                $sql .= ' UNION ALL SELECT ' . $key . ",'" . $value . "'" ;
            }
            $i++;
        }
        return $sql;
    }

    /**
     * get List
     * @param $table
     * @param string $field
     * @param bool $sort
     * @param null $where
     * @return array
     */
    public static function getList($table, $field = '', $sort = true, $where = 1) {
        //DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);
        $sfield = null;
        $res = array();
        if ($sort === true) {
            $field = $field ? $field : substr($table, 1, strlen($table) + 1);
        } elseif (gettype($sort) == 'string') {
            $sfield = $sort;
        }
        $fid = substr($table . "id", 1, strlen($table) + 1);
        $res = DB::table($table)
            ->whereRaw($where)
            ->orderByRaw(($sfield ? $sfield : ($field ? $field : $fid)))
            ->lists($field);
        return $res;
    }

    public static function deleteFile($id, $folder = '') {
        $path = $folder ? "/$id" : "/$folder/$id";
        File::delete(config('upload.' . config('app.controller')) . $path);
    }

     /**
     * Sync the intermediate tables with a list of IDs or collection of models.
     *
     * @param  \Illuminate\Database\Eloquent\Collection|\Illuminate\Support\Collection|array  $ids
     * @param  bool   $detaching
     * @return array
     */
    public static function syncOneToMany($values,$primaryKey,$forigen_key, $detaching = true)
    {
        $instance = new static();
        $changes = [
            'attached' => [], 'detached' => [], 'updated' => [],
        ];

        // First we need to attach any of the associated models that are not currently
        // in this joining table. We'll spin through the given IDs, checking to see
        // if they exist in the array of current ones, and if not we will insert.
        $current = $instance->where($forigen_key,$primaryKey)->pluck(
            $instance->primaryKey
        )->toArray();
              
        $detach = array_diff($current, array_keys(
            $records = $instance->formatRecordsList($values,$instance->primaryKey)
        ));

        // Next, we will take the differences of the currents and given IDs and detach
        // all of the entities that exist in the "current" array but are not in the
        // array of the new IDs given to the method which will complete the sync.
        if ($detaching && count($detach) > 0) {
            $instance->destroy($detach);
            $changes['detached'] = $instance->castKeys($detach);
        }

        // Now we are finally ready to attach the new records. Note that we'll disable
        // touching until after the entire operation is complete so we don't fire a
        // ton of touch operations until we are totally done syncing the records.
        
        foreach ($records as $id => $attributes) {
            $attributes[$forigen_key] = $primaryKey;
            if (! in_array($id, $current)) {
                $instance->create($attributes);
                $changes['attached'][] = $instance->castKey($id);
            }else{
                $instance->updateById($attributes,$id);
                $changes['updated'][] = $instance->castKey($id);
            }  
        }

        return $changes;
    }

   

    /**
     * Format the sync / toggle record list so that it is keyed by ID.
     *
     * @param  array  $records
     * @return array
     */
    protected function formatRecordsList(array $records,$primaryKey)
    {
        return collect($records)->mapWithKeys(function ($attributes, $id) use ($primaryKey) {
            if (! is_array($attributes)) {
                [$id, $attributes] = [$attributes, []];
            }
            $key = $attributes[$primaryKey];
           // unset($attributes[$primaryKey]);
            return $key ? [$key => $attributes] : [\Str::random(12) => $attributes];
        })->all();
        
    }

    /**
     * Cast the given keys to integers if they are numeric and string otherwise.
     *
     * @param  array  $keys
     * @return array
     */
    protected function castKeys(array $keys)
    {
        return array_map(function ($v) {
            return (int)$v;
        }, $keys);
    }

     /**
     * Cast the given key to convert to primary key type.
     *
     * @param  mixed  $key
     * @return mixed
     */
    protected function castKey($key)
    {
        return (int)$key;
    }
}