<?php namespace App\Models;
use App;
use FarsiLib;
use Illuminate\Database\Eloquent\Builder;

class CustomEloquentBuilder extends Builder {

    /**
     * Save a new model and return the instance.
     *
     * @param  array  $attributes
     * @return \Illuminate\Database\Eloquent\Model|$this
     */
    public function create(array $attributes = []) {
        if ($this->model->lang) {
            $values['xlang'] = App::getLocale();
        }

        if (array_key_exists('xrank', $attributes) && $attributes['xrank'] == '') {
            $attributes['xrank'] = 0;
        }

        foreach ($attributes as $key => $value) {
            $attributes[$key] = self::cast($key, $value);
        }

        return parent::create($attributes);
    }

    /**
     * Update a record in the database.
     *
     * @param  array  $values
     * @return int
     */
    public function update(array $values) {
        if (array_key_exists('xrank', $values) && $values['xrank'] == '') {
            $values['xrank'] = 0;
        }

        foreach ($values as $key => $value) {
            $values[$key] = self::cast($key, $value);
        }

        return parent::update($values);
    }

    /**
     * Create or update a record matching the attributes, and fill it with values.
     *
     * @param  array  $attributes
     * @param  array  $values
     * @return \Illuminate\Database\Eloquent\Model|static
     */
    public function updateOrCreate(array $attributes, array $values = []) {
        if ($this->model->lang) {
            $values['xlang'] = App::getLocale();
        }

        if (array_key_exists('xrank', $values) && $values['xrank'] == '') {
            $values['xrank'] = 0;
        }

        foreach ($values as $key => $value) {
            $values[$key] = self::cast($key, $value);
        }

        return parent::updateOrCreate($attributes, $values);
    }

    /**
     * Execute the query as a "select" statement.
     *
     * @param  array  $columns
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function getWithLocale($columns = ['*']) {
        $this->query->where('xlang', App::getLocale());
        return parent::get($columns);
    }

    /**
     * Execute the query as a "select" statement.
     *
     * @param  array  $columns
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function getWithStatus($columns = ['*']) {
        $this->query->where('xstatus', 1);
        return parent::get($columns);
    }

    public function findWith($id) {
        $relataions = $this->model->getRelations();
        return parent::with($relataions)->find($id);
    }

    private function cast($key, $value) {
        if ($value === '') {return null;}
        $cast = null;
        if (array_key_exists($key, $this->model->getCasts())) {
            $cast = $this->model->getCasts()[$key];
        }

        switch ($cast) {
        case 'int':
            return (int) $value;
            break;

        case 'j2timestamp':
            $date = is_string($value) ? new \DateTime(FarsiLib::j2gDate($value)) : $value;
            return $date;
            break;

        default:
            return $value;
            break;
        }
    }

    public function resetWhere(){
        $cname = 'wheres';
        $unions = false;
        $this->query->{$cname} = [];
        $this->query->bindings['where'] = [];
        return $this;
    }

    public function getKeyName(){
        return $this->model->getKeyName();
    }

}