<?php

namespace App\Http\Middleware;

use App\Entities\Permission;
use App\Exceptions\PermissionDeniedException;
use Auth;
use Closure;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;
use Session;

class VerifyPermission {
    /**
     * @var Guard
     */
    protected $auth;

    /**
     * Create a new filter instance.
     *
     * @param Guard $auth
     */
    public function __construct(Guard $auth) {
        $this->auth = $auth;
    }

    /**
     * Handle an incoming request.
     *
     * @param Request    $request
     * @param \Closure   $next
     * @param int|string $permission
     *
     * @throws \jeremykenedy\LaravelRoles\Exceptions\PermissionDeniedException
     *
     * @return mixed
     */
    public function handle($request, Closure $next) {
        $controller = $request->route('controller');
        $controller = $controller ?? 'Home';
        $module = config('route.' . trim($controller));
        $action = $request->route('action');

        $permission = new Permission($module, $controller, $action);
        
        if ($this->auth->check() && $this->auth->user()->hasPermission($permission)) {
            return $next($request);
        }

        return abort(404);
    }
}
