<?php

//## clear view cache
if (!function_exists('clearCache')) {
    function clearCache() {
        $cachedViewsDirectory = base_path() . '/storage/framework/views/';
        $files = glob($cachedViewsDirectory . '*');
        foreach ($files as $file) {
            if (is_file($file)) {
                File::delete($file);
            }
        }
    }
}

//## convertDigit
if (!function_exists('convertDigit')) {
    function convertDigit($number, $html = false) {
        return FarsiLib::convertDigit($number, $html);
    }
}

//## translate
if (!function_exists('t')) {
    function t($msg) {
        $lang = config('custom.site.lang') . '.';
        if (strpos($msg, 'language.') === 0) {
            $lang = '';
        }

        if (str_contains($msg, '::')) {
            return trans($msg);
        }

        $module = camel_case(config('app.module'));
        if (Lang::has($module . '::' . $lang . $msg)) {
            return trans($module . '::' . $lang . $msg);
        }

        return trans($lang . $msg);
    }
}

//## farsi date
if (!function_exists('farsiDate')) {
    function farsiDate($param, $format = "Y-m-d", $farsiDigit = true) {
        $date =  FarsiLib::jDate($format, 0, 0, strtotime($param));
        return ($farsiDigit ? FarsiLib::en2faDigit($date) : $date);
    }
}

//## translation explode
if (!function_exists('transExplode')) {
    function transExplode($msg, $seperator = ',', $perfix = 'language', $returnSeperator = '، ') {
        return Lib::transExplode($msg, $seperator, $perfix, $returnSeperator);
    }
}
//## getCurrentURL
if (!function_exists('getCurrentURL')) {
    function getCurrentURL($partname = '', $siteurl_perfix = false) {
        return Lib::getCurrentURL($partname, $siteurl_perfix);
    }
}

//## alert
if (!function_exists('alert')) {
    function alert($msg) {
        return Trace::alert($msg);
    }
}

//## trace
if (!function_exists('trace')) {
    function trace($msg, $die = false, $dir = 'ltr') {
        $title = null;
        if (is_string($die)) {
            $title = $die;
            $die = ($dir == 'ltr') ? 0 : $dir;
        }
        Trace::add($msg, $title, $dir);
        Trace::flush();

        if ($die) {
            die;
        }

    }
}

//## trace all
if (!function_exists('traceAll')) {
    function traceAll($die = false, $dir = 'ltr') {
        $allInfo['GET'] = @$_GET;
        $allInfo['POST'] = @$_POST;
        $allInfo['SESSION'] = @$_SESSION;
        $allInfo['COOKIE'] = @$_COOKIE;
        $allInfo['FILES'] = @$_FILES;
        $allInfo['REQUEST'] = @$_REQUEST;
        trace($allInfo, $die, $dir);
    }
}

//##
if (!function_exists('htmlStatus')) {
    function htmlStatus($item, $status = []) {
        if (is_null($item)) {
            return null;
        }

        $result = "<div class='text-center'><span class='label label-sm label-default'>" . t($item) . "</span></div>";
        foreach ($status as $key => $value) {
            if ($item == $key) {
                $tkey = $key;
                if ($key == "0") {
                    $tkey = 'inactive';
                } else if ($key == "1") {
                    $tkey = 'active';
                }

                $result = "<div class='text-center'><span class='label label-sm label-{$value}'>" . t($tkey) . "</span></div>";
                break;
            }
        }
        return $result;
    }
}

if (!function_exists('imageUrl')) {
    function imageUrl($type, $id, $width = 135, $height = 200) {
        $result = "/pic/{$type}/" . $id . "w{$width}h{$height}c1/" . str_random() . '.jpg?nocache=1';
        return $result;
    }
}

//## create file json of language
function jsLanguage($file = '', $dest = '', $gc = 10) {
    $file = ($file ? $file : (base_path() . '/resources/lang/' . App::getLocale()));
    $fileName = '';

    if (File::exists($file)) {
        $fileList = array();
        if (is_dir($file)) {
            foreach (File::glob($file . '/*.php') as $key => $filePath) {
                $fileList[$filePath] = File::lastModified($filePath);
            }
        } else {
            $fileList = array($file => File::lastModified($file));
        }

        $crc32 = crc32(json_encode($fileList));

        $dest = $dest ? (public_path() . $dest) : (public_path() . '/assets/cache/');
        $fileName = 'language_' . $crc32 . '.js';
        if (!is_dir($dest)) {
            File::makeDirectory($dest, 0777, true);
        }

        if (!File::exists($dest . $fileName)) {
            $language = array();
            foreach ($fileList as $filePath => $lastModified) {
                $language = array_merge($language, array_dot(File::getRequire($filePath)));
            }
            $translate = '{';
            if ($language) {
                $cntLang = 0;
                foreach ($language as $kl => $vl) {
                    $cntLang++;
                    if (is_array($vl)) {
                        continue;
                    }

                    $translate .= '"' . e($kl) . '":"' . e($vl) . '"' . ($cntLang < count($language) ? ',' : '');
                }
                $translate .= "};";
            }
            $destFile = "var translate=" . $translate;

            //## delete language file
            $langFileList = File::glob($dest . 'language_*.js');
            if (count($langFileList) >= $gc) {
                foreach ($langFileList as $langFile) {
                    File::delete($langFile);
                }
            }
            // set new file
            File::put($dest . $fileName, $destFile);
        }
    }
    return $fileName;
}

//## compress assets
function compareAssets($assets = array(), $gc = 20) {
    //md5(implode($assets));
    $css_regex = '/.\.css$/i';
    $js_regex = '/.\.js$/i';
    $timestamp = config('assets.pipeline');
    if (is_array($assets) and $timestamp) {
        $fileList = array();
        $cacheDir = config('assets.css_dir');
        $ext = 'css';
        foreach ($assets as $key => $val) {
            $filePath = public_path() . $val;
            if (File::exists($filePath)) {
                $fileList[$filePath] = File::lastModified($filePath);
                if (preg_match($js_regex, $val)) {
                    $cacheDir = config('assets.js_dir') ? config('assets.js_dir') : $cacheDir;
                    $ext = 'js';
                }
            }
        }
        $timestamp = crc32(json_encode($fileList));
        $cacheDir = public_path() . $cacheDir . '/' . config('assets.pipeline_dir');
        $cacheFile = $cacheDir . '/' . md5('?' . $timestamp . implode($assets)) . '.' . $ext;
        if (!File::exists($cacheFile) and count(File::allFiles($cacheDir)) > $gc) {
            foreach (glob($cacheDir . '/*') as $file) {
                if (preg_match("/\/[0-9a-f]{32}(?:[0-9a-f]{8})?\.$ext/i", $file)) {
                    File::delete($file);
                }
            }
        }
    }

    return $timestamp;
}

// restore lost tags
function restoreTags($input) {
    $opened = array();

    // loop through opened and closed tags in order
    if (preg_match_all("/<(\/?[a-z][a-z1-6]*)>?/i", $input, $matches)) {
        foreach ($matches[1] as $tag) {
            if (preg_match("/^[a-z][a-z1-6]*$/i", $tag, $regs)) {
                // a tag has been opened
                if (!preg_match('/^(br|input|hr|meta|base|basefont)$/i', $regs[0])) {
                    $opened[] = $regs[0];
                }

            } elseif (preg_match("/^\/([a-z][a-z1-6]*)$/i", $tag, $regs)) {
                // a tag has been closed
                $keys = array_keys($opened, $regs[1]);
                unset($opened[array_pop($keys)]);
            }
        }
    }

    // close tags that are still open
    if ($opened) {
        $tagstoclose = array_reverse($opened);
        foreach ($tagstoclose as $tag) {
            $input .= "</$tag>";
        }

    }

    return $input;
}

// truncate text smart
function truncate($string, $limit, $break = " ", $pad = "...") {
    // return with no change if string is shorter than $limit
    if (strlen($string) <= $limit) {
        return $string;
    }

    // is $break present between $limit and the end of the string?
    if (($breakpoint = strpos($string, $break, $limit)) !== false) {
        if ($breakpoint < strlen($string) - 1) {
            $string = restoreTags(substr($string, 0, $breakpoint)) . $pad;
        }
    }

    return $string;
}

if (!function_exists('IsValidNationalCode')) {
    function IsValidNationalCode($nationalCode) {
        if(!preg_match('/^[0-9]{10}$/',$nationalCode))
            return false;
        for($i=0;$i<10;$i++)
            if(preg_match('/^'.$i.'{10}$/',$nationalCode))
                return false;
        for($i=0,$sum=0;$i<9;$i++)
            $sum+=((10-$i)*intval(substr($nationalCode, $i,1)));
        $ret=$sum%11;
        $parity=intval(substr($nationalCode, 9,1));
        if(($ret<2 && $ret==$parity) || ($ret>=2 && $ret==11-$parity))
            return true;
        return false;
    }
}

if(!function_exists('isImageExist')){
    function isImageExist($id, $folder){
        return File::exists(config('upload.' . \Str::ucfirst(config('app.controller'))). "/{$folder}" . "/$id");
    }
}
