<?php namespace App\Http\Controllers;

use Input;
use App;
use File;
use Response;
use Intervention\Image\Facades\Image;
use Modules\Page\Models\Widget;

class PicController extends Controller {

    /**
     * Show the user profile.
     */
    public function index($folders, $name, $output)
    {
        
        $ossProcess = Input::get('x-oss-process');
        $folderList = explode('.', $folders);
        $ext = 'jpg';
        $noCache = Input::get('nocache');
        // $noCache = (env('APP_ENV') == 'local' or $noCache) ? true : false;
        $quality = 90;
        $default= null;

        if($ossProcess){
            $output = preg_replace('/[^A-Za-z0-9\-]/', '', $ossProcess);
            preg_match('/([^\.]*)\.?(jpg|gif|png|bmp|webp|tiff)/', $name, $outputMatch);
            $fileName = $outputMatch ? @$outputMatch[1] : null;
            $ext = $outputMatch ? @$outputMatch[2] : $ext;
            $pattern = '/image\/((?:resize(?:(?:h_(\d+))|(?:w_(\d+))|(?:m_([a-z]+))|,)*)|(?:quality(?:(?:q_(\d+))|,)*)|(?:indexcrop(?:(?:x_(\d+))|(?:i_(\d+))|,)*)|(?:default(?:(?:n_(\w+))|,)*)|\/)*/';
            preg_match($pattern,$ossProcess,$fileMatch);

            if ($fileMatch) {
                $height = @$fileMatch[2] ? $fileMatch[2] : null;
                $width = @$fileMatch[3] ? $fileMatch[3] : null;
                $resizeType = @$fileMatch[4] ? $fileMatch[4] : null;
                $quality = @$fileMatch[5];
                $crop = @$fileMatch[6];
                $rotate = @$fileMatch[7];
                $default = @$fileMatch[8];
            }
        
        }else{
            preg_match('/([a-z]*\d+)(?:(?:w(\d+))|(?:h(\d+))|(?:mw(\d+))|(?:mh(\d+))|(?:c(\d+))|(?:r(-?\d+))|(?:q(-?\d+)))*/', $name, $fileMatch);
            preg_match('/[^\.]*\.?(jpg|gif|png)/', $output, $outputMatch);
            $ext = $outputMatch ? @$outputMatch[1] : $ext;
            
            if ($fileMatch) {
                $fileName = @$fileMatch[1];
                $width = @$fileMatch[2] ? $fileMatch[2] : null;
                $height = @$fileMatch[3] ? $fileMatch[3] : null;
                $maxWidth = @$fileMatch[4] ? $fileMatch[4] : null;
                $maxHeight = @$fileMatch[5] ? $fileMatch[5] : null;
                $crop = @$fileMatch[6];
                $rotate = @$fileMatch[7];
                $quality = @$fileMatch[8];
            }
        }
        
        $contentType = 'Content-Type: image/' . $ext;
        
        $filePath = public_path() . '/777/';
        $cacheFolder = public_path() . '/pic/' . str_finish(implode('/',$folderList ), '/') . $fileName .'/';
        $cachePath = $cacheFolder . ($ossProcess ? str_replace('/','-',$ossProcess) :"{$name}");
        
        
        if (File::exists($cachePath)) {
            header ($contentType);
            echo File::get($cachePath);
            die;
        }

        if ($folderList) {
            foreach ($folderList as $folder) {
                if (!trim($folder)) continue;
                $filePath .= $folder . '/';
            }
        }

        $filePath .= $fileName;

        if (!File::exists($filePath)) {
            $img = $this->getDefaultImage($default);
        } elseif($ext == 'gif'){
            return response()->file($filePath);
        } else {
            $img = Image::make($filePath);
            if ($width or $height or $crop) { //## resize (and/or) crop
                $img = $this->resize($img, $width, $height, $crop);
            }

            if (@$maxWidth or @$maxHeight) { //## max height & max width             
                $img = $img->resize($maxWidth, $maxHeight, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                });  
            }

            if ($rotate) { //## rotate
                $img->rotate($rotate);
            }

            if (!$noCache) {
                if (!is_dir($cacheFolder))
                    File::makeDirectory($cacheFolder, 0755, true);
                $img->save($cachePath, $quality);
            }
        }

        header ($contentType);
        echo  $img->encode($ext);
        die;        
    }

    //## resize image
    public function resize($img, $width, $height, $crop = false)
    {
        if($crop) { //## Crop
            $height = $height ? $height : $img->height();
            $width = $width ? $width : $img->width();
            if($crop == 2){
                if($width < $height)
                    $img = $img->widen($width);
                else
                    $img = $img->heighten($height);
            }
            $img = $img->fit($width, $height);
        } else { //## resize
            if ($width and !$height) {
                // resize the image to a width of 300 and constrain aspect ratio (auto height)
                $img->resize($width, null, function ($constraint) {
                    $constraint->aspectRatio();
                });
            } else if (!$width and $height) {
                // resize the image to a height of 200 and constrain aspect ratio (auto width)
                $img->resize(null, $height, function ($constraint) {
                    $constraint->aspectRatio();
                });
            } else if ($width and $height) {
                $img->resize($width, $height);
            }
        }
        return $img;
    }

    private function getDefaultImage($default){
        switch ($default) {
            case 'project':
                $filePath = public_path() . '/admin/media/project-logos/'. rand(1,7) . '.png';
                return Image::make($filePath);
                break;
            
            case 'user':
                $filePath = public_path() . '/admin/media/users/'. rand(1,20) . '.jpg';
                return Image::make($filePath);
                break;
            default:
                return Image::canvas(1, 1); // create null image
                break;
        }
    }

    //## download a file
    public function download($folders, $name, $cid, $output)
    {
        $folderList = explode('.', $folders);
        $path = public_path() . '/777/';
        $folders = '';
        if ($folderList) {
            $cnt = 1;
            foreach ($folderList as $folder) {
                $path .= $folder . '/';
                $folders .= $folder . ($cnt < count($folderList) ? '.' : '');
                $cnt++;
            }
        }
        $path .= $name;
        $folders .= ('/' . $name);

        // if (md5($folders . env('APP_KEY')) != $cid) {
        //     return abort(403);
        // }

        if (File::exists($path)) {
            return Response::download($path, $output);
        } else {
            return abort(404);
        }
    }

}