<?php namespace App\Http\Controllers;

use App;
use Config;
use Modules\Blog\Models\ArticleGroup;
use Modules\Book\Models\Category;
use Modules\Home\Models\Config as ConfigModel;
use Modules\Home\Models\Menu;
use Modules\Page\Models\Page;
use Modules\Social\Models\Social;
use Modules\Shop\Models\Group;
use View;
use Jenssegers\Agent\Agent;

abstract class IndexController extends Controller {
    public $title;
    public $lang;
    public $config;

    protected $layout;
    protected $theme;

    public function __construct() {
        if(!$this->layout){
            $this->theme = config('app.theme','cppc');
            $this->layout = 'index.' . $this->theme . '.layout';
        }
        
        $social = Social::orderBy('xrank', 'desc')->get();
        $articleGroup = ArticleGroup::getWithLocale();

        $config = ConfigModel::getWithLocale()->first();
        $config = json_decode($config->xconfig_data, true);

        $this->config = $config;
        $this->title = $config['seo']['title'];

        Config::set('cart.discount.extra.threshold', $this->config['discount']['extra']['threshold']);
        Config::set('cart.discount.extra.lower', $this->config['discount']['extra']['lower']);
        Config::set('cart.discount.extra.upper', $this->config['discount']['extra']['upper']);
        Config::set('cart.discount.extra.action', $this->config['discount']['extra']['action']);

        Config::set('cart.post.status', (int)$this->config['post']['status']);
        Config::set('cart.post.threshold', $this->config['post']['threshold']);
        Config::set('cart.post.bikepost.price', $this->config['post']['bikepost']['price']);
        Config::set('cart.post.bikepost.status', (int)$this->config['post']['bikepost']['status']);
        Config::set('cart.post.normalpost.base', $this->config['post']['normalpost']['base']);
        Config::set('cart.post.normalpost.per', $this->config['post']['normalpost']['per']);
        Config::set('cart.post.normalpost.status', (int)$this->config['post']['normalpost']['status']);
        Config::set('cart.post.notCompute', explode(',',$this->config['post']['notCompute']));

        Config::set('cart.payment.method.online', (int)$this->config['payment']['method']['online']);
        Config::set('cart.payment.method.offline', (int)$this->config['payment']['method']['offline']);
        Config::set('cart.payment.method.cart', (int)$this->config['payment']['method']['cart']);
        
        $menus = Menu::where('xstatus',1)->where('parent_id',0)->orderBy('xrank','desc')->getWithLocale();
        $agent = new Agent();
        
        View::share([
            'maintitle' => 'text',
            'social' => $social,
            'menus' => $menus,
            'config' => $config,
            'articleGroup' => $articleGroup,
            'agent' => $agent,
        ]);
    }

    protected function setupLayout() {
        if (env('APP_ENV') == 'local') {
            clearCache();
        }
        if (!is_null($this->layout)) {
            $this->layout = view($this->layout, array('title' => $this->title));
        }
        if (method_exists($this, 'setCombo')) {
            $this->setCombo();
        }
        $this->startUp();
    }

    public function startUp() {
    }

    private function getPageChilds($pages, $item, $templateStart = '<li>{$title}', $templateEnd = '</li>') {
        $result = "";
        foreach ($pages as $key => $value) {
            if ($value->xparentid == $item && (int) $value->xpage_menu == 1) {
                $childs = self::getPageChilds($pages, $value->xpageid, $templateStart, $templateEnd);

                $result .= strtr($templateStart, [
                    '{$title}' => $value->xpage_title,
                    '{$href}' => $childs ? '#' : "/" . App::getLocale() . "/Page/{$value->xpageid}/{$value->xpage_title}",
                    '{$liClass}' => $item ? 'nis-item' : ($childs ? 'nav-item hasChildren' : 'nav-item'), //$childs ? 'dropdown' : '',
                    '{$aClass}' => $item ? 'c-navi-new__big-display-title' : 'nav-link', //$childs ? 'dropdown-toggle' : '',
                    '{$dataToggle}' => $childs ? 'data-toggle="dropdown"' : '',

                ]);

                if ($childs) {
                    $result .= "<div class='nav-item-sublist'><div class='nav-item-sublist-container'>
                            <ul> {$childs} </ul></div></div>" . $templateEnd;
                } else {
                    $result .= $templateEnd;
                }

            }
        }
        return $result;
    }
}