<?php namespace App\Http\Controllers;

use App\Services\Query;
use Config;
use DB;
use Str;
use Exception;
use File;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use Input;
use Request;
use App\Exports\Export;

class BackendController extends Controller {
    public $title;
    public $query;
    public $list;
    public $view = 'admin';
    public $adminStatus = 'offline';
    public $perPage;
    protected $layout = 'newadmin.layout.default';
    protected $model;
    public $lang;

    public function __construct() {
        $queryItem = Request::get('q');
        $this->lang = config('custom.site.lang');

        //## set list limit
        if (@$_COOKIE['perPage']) {
            Config::set('custom.perPage', $_COOKIE['perPage']);
        }

        if (@$queryItem['limit']['count']) {
            Config::set('custom.perPage', $queryItem['limit']['count']);
        }
        $this->perPage = config('custom.perPage', 10);

        //## search
        $this->query = new Query($queryItem);
        //dd($queryItem);
    }

    private function calculateFields(){
        $newFields = $this->fields;
        foreach ($newFields as $fieldKey => $field) {
            if(@$field['type'] == 'wizard'){
                foreach ($field['items'] as $key => $value) {
                    $newFields[$key] = $value;
                }
                unset($newFields[$fieldKey]);
            }else{
                unset($newFields[$fieldKey]);
                $newFields[$fieldKey] = $field;
            }
        }
        return [
            'fields' => $newFields,
            'scaffold' => $this->scaffold
        ];
    }

    public function getFields()
    {
        $fields = $this->calculateFields();
        return response()->json($fields, 200);
    }

    public function getDetail($id){
        $item = $this->model->find($id);
        foreach ($this->fields as $key => $value) {
            if(@$value['type'] == 'json'){
                $item[$value['name']] = json_decode($item[$value['name']],true);
            }
        }
        return response()->json($item, 200);
    }

    public function getData()
    {
        if(!$this->model) return;
        
        $parameters = Input::all();
        
        $totalCount = $this->model->count();
        $filteredCount = $this->model->count();
        $dataset = $this->model->limit(@$parameters['length'] ?? 10)->skip(@$parameters['start'] ?? 0);
        if(@$parameters["draw"] != 1){
            $dataset =  $dataset->resetWhere();
        }
       
        foreach ($parameters['columns'] ?? [] as $key => $value) {
            if(!empty($value['search']['value']) || $value['search']['value'] == '0'  ){
                switch ($this->processFieldType($this->fields,$value['data'])) {
                    case 'text':
                        $dataset->where($value['data'],'like',Str::finish(Str::start($value['search']['value'],'%'),'%'));
                        break;
                    case 'number':
                    case 'comboBox':
                    case 'folderList':
                    case 'switch':
                        $dataset->where($value['data'],$value['search']['value']);
                        break;
                    
                    default:
                        # code...
                        break;
                }
                
            }
        }
        //dd($dataset->toSql());
        $dataset = $dataset->get();
        $dataResult = [];
        if (!empty($dataset) and $dataset->count()) {
            $id = @$dataset->first()->getKeyName();
            foreach ($dataset as $data) {
                $row = [];
                $row["DT_RowId"] = $data->$id;
                if ($this->scaffold['checkbox'])
                    $row["checkbox"] = null;

                foreach ($this->fields as $field) {
                    if(@$field['type'] == 'wizard'){
                        foreach ($field['items'] as $field2) {
                            $fieldName = @$field2['name'];
                            if($fieldName) $row[$fieldName] = $data->$fieldName;
                        }
                    }elseif(@$field['type'] == 'json'){
                        $fieldName = @$field['name'];
                        if($fieldName) $row[$fieldName] = json_decode($data->$fieldName,true);
                    }elseif(@$field['type'] == 'dynamicComboBox'){
                        $fieldName = @$field['name'];
                        $fieldValue = @$field['value'];
                        
                        if($fieldName && @$data->$fieldName) {
                            $row[$fieldName] = $data->$fieldName->$fieldValue;
                        }
                    }
                    else{
                        $fieldName = @$field['name'];
                        if($fieldName) $row[$fieldName] = $data->$fieldName;
                    }
                }
                $dataResult[] = $row;
            }
        }

        $data = [
            "draw" => @$parameters["draw"] ?? 0,
            "recordsTotal" => $totalCount,
            "recordsFiltered" => $filteredCount,
            "data" => $dataResult
        ];

        return response()->json($data, 200);

    }

    /**
     * Count Query Result
     */
    public function queryCount($stmt, $maxLimit = 10000, $addSelect = []) {
        if (is_array($stmt->columns)) {
            foreach ($stmt->columns as $key => $col) {
                if (trim($col) == '*' or preg_match('/[^\s]+\.\*$/', $col)) {
                    unset($stmt->columns[$key]);
                }
            }
        }

        if ($addSelect) {
            $stmt->addSelect($addSelect);
        }

        $bindings = $stmt->getBindings();
        $countStmt = $stmt->skip(0)->take($maxLimit);
        $countStmt->orders = null;
        $sql = $countStmt->toSql();

        foreach ($bindings as $val) {
            $sql = preg_replace('/\?/', "'{$val}'", $sql, 1);
        }
        return $stmt->getConnection()->table(DB::raw("($sql) as countStmt"))
            ->addSelect([DB::raw('COUNT(*) as total')]);
    }

    protected function setQueryToList() {
        if (!is_array($this->list) and $this->query) {
            if ($this->query->where and !intval($this->query->where)) {
                //## where
                $this->query->wheres = null;
                $this->list->whereRaw($this->query->where);
            }
            if ($this->query->having and !intval($this->query->having)) {
                //## having
                $this->list->havings = null;
                $this->list->havingRaw($this->query->having);
            }
            if ($this->query->group) {
                //## group by
                $this->list->groups = null;
                $this->list->groupBy(explode(',', $this->query->group));
            }
            if ($this->query->order AND $this->query->order != 'NULL') {
                //## order by
                $this->list->orders = null;
                $this->list->orderByRaw($this->query->order);
            }

            $this->list = $this->list
                ->skip($this->query->skip)
                ->take($this->query->take);
            $columns = $this->list->columns;
            $orders = $this->list->orders;
            //## get count of query
            //dd($this->list->toSql());
            $count = $this->queryCount($this->list)->count();
            
            //## get query
            $this->list->columns = $columns;
            $this->list->orders = $orders;
            $this->list
                ->skip($this->query->skip)
                ->take($this->query->take);

            return $count;
        } else {
            throw new Exception('Deprecated ModelName::getResult($this->query)->get(), please use ModelName::getResult()', 1);
        }

    }

    public function index(){
        switch (@$this->scaffold['listView']) {
            case 'project':
                $view = 'newadmin.layout.component._projects';
                break;

            case 'folder':
                $view = 'newadmin.layout.component._folders';
                break;
            
            default:
                $view = 'newadmin.layout.component._list';
                break;
        }
        $params = $this->calculateFields();
       

        if (Request::ajax()) {
            $this->layout = view('backend.ajax');
        }
        if ($view) {
            $this->layout->content = (is_object($view) ? $view : view($view, $params));
        }
        if (method_exists($this, 'setCombo')) {
            $this->setCombo();
        }
    }

    private function processFieldType($fields,$name){
        foreach ($fields as $key => $field) {
            if(array_key_exists('type',$field)){
                if($field['type'] == 'wizard'){
                    return $this->processFieldType($field['items'],$name);
                }else{
                    if ($field['name'] == $name) 
                        return $field['type'];
                }
            }
        }
        return null;
    }

    private function processFieldToExcel($fields){
        $result = [];
        foreach ($fields as $key => $field) {
            if(array_key_exists('type',$field)){
                if($field['type'] == 'wizard'){
                    $result = array_merge($result,$this->processFieldToExcel($field['items']));
                }elseif($field['type'] == 'form' || $field['type'] == 'elequentRelation'){
                    continue;
                }else{
                    $result[$field['name']] = $field['text'];
                }
            }
        }
        return $result;
    }

    public function exportExcel() {
        $checkall = Input::get('listAllCheckbox');
        $listchk = Input::get('listCheckbox');
        
        $result = $this->processFieldToExcel($this->fields);
        
        $list = $this->model->select(array_keys($result));
        
        if (!$checkall && $listchk) {
            $list->whereIn($this->model->getKeyName(), array_keys($listchk));
        }
        
        return (new Export($list,array_values($result)))->download(Str::random(20) . '.xlsx');
    }

    /**
     * Paginage List
     */
    protected function paginate($view = 'newadmin.layout.component._list', $params = [], $callBack = '') {
        //$count = 0;

        //$count = $this->setQueryToList();
        //$this->list = $this->list->get();

        //## run clouser after list
        if (is_callable($view)) {
            $this->list = $view($this->list);
            $view = 'newadmin.layout.component._list';
        }

        if (is_callable($params)) {
            $this->list = $params($this->list);
            $params = [];
        }

        if (is_callable($callBack)) {
            $this->list = $callBack($this->list);
        }

        $this->list = new Paginator($this->list, @$count, $this->perPage, null, [
            'path' => Request::url(),
            'query' => Request::query(),
        ]);

        $params = ($params ? $params : [
            'list' => $this->list,
            'fields' => @$this->fields,
            'scaffold' => @$this->scaffold,
        ]);

        if (Request::ajax()) {
            $this->layout = view('backend.ajax');
        }
        if ($view) {
            $this->layout->content = (is_object($view) ? $view : view($view, $params));
        }
    }

    /**
     * Setup Layout
     */
    protected function setupLayout() {
        if (env('APP_ENV') == 'local') {
            clearCache();
        }

        $currentSection = camel_case(config('app.section'));
        $currentModule = camel_case(config('app.module'));
        $currentController = camel_case(config('app.controller'));
        $currentAction = config('app.action');

        $viewPath = base_path() . '/Modules/' . config('app.module') . '/Resources/views/';

        if (!is_null($this->layout)) {
            $view = $searchView = config('custom.view.' . studly_case($currentSection), config('custom.view.' . studly_case($currentSection)));

            if (is_array($view)) {
                foreach ($view as $sec => $v) {
                    $v = camel_case($v);
                    $editViewExist = File::exists($viewPath . $v . '/edit/' . $currentController . '.blade.php') or
                    File::exists($viewPath . $v . '/edit/' . $currentController . '.php');
                    $searchViewExist = File::exists($viewPath . $v . '/search/' . $currentController . '.blade.php') or
                    File::exists($viewPath . $v . '/search/' . $currentController . '.php');

                    $viewExist = ($editViewExist or $searchViewExist);
                    if ((preg_match('/^\w/', $sec) and strtolower(trim($sec)) == strtolower($currentSection)) and $viewExist) {
                        if ($searchViewExist) {
                            $searchView = $v;
                        } else {
                            $view = $v;
                        }
                    } elseif (strtolower(trim($v)) == strtolower($currentSection) and $viewExist) {
                        if ($searchViewExist) {
                            $searchView = $v;
                        } else {
                            $view = $v;
                        }
                    } elseif ($viewExist) {
                        if ($searchViewExist) {
                            $searchView = $v;
                        } else {
                            $view = $v;
                        }
                    }
                }

                $view = is_array($view) ? $view[0] : camel_case($view);
                $searchView = is_array($searchView) ? $searchView[0] : camel_case($searchView);
            }

            $this->view = $view ? camel_case($view) : 'admin';
            $this->searchView = $searchView ? camel_case($searchView) : 'admin';

            $this->layout = view($this->layout, [
                'title' => $this->title,
                'lang' => $this->lang,
                'sectionTitle' => $this->getSectionTitle(),
            ]);
            
            $searchFile = $viewPath . $this->searchView . '/search/' . $currentController;
            $this->layout->content = view('backend.default', ['lang' => $this->lang]);
            
            if (File::exists($searchFile . '.blade.php') or File::exists($searchFile . '.php')) {
                $this->layout->tplsearch = $currentModule . '::' . $this->searchView . '.search.' . $currentController;
            }

            if (preg_match('/^create\_?|^edit\_?/i', $currentAction)) {
                $this->layout = view('newadmin.layout.' . (Request::ajax() ? 'component._edit' : 'default'));
                if (!Request::ajax()) {
                    $this->layout->custom = true;
                    $this->layout->viewEdit = true;
                }
                if(@$this->customEdit){
                    $currentView = $viewPath . $this->view . '/edit/' . $currentController;

                    if (File::exists($currentView . '.blade.php') or File::exists($currentView . '.php')) {
                        $this->layout->content = view($currentModule . '::' . $this->view . '.edit.' . $currentController, ['lang' => $this->lang, 'title' => $this->title]);
                    } else {
                        $this->layout->content = view('backend.default');
                    }
                }else{
                    $this->layout->content = view('newadmin.layout.component._edit');
                    $this->layout->content->fields = $this->fields;
                }
                

            }
            if (method_exists($this, 'setCombo')) {
                $this->setCombo();
            }
        }
       
    }

    /**
     * @param $id
     * @param array $gallery
     * @param string $folder / config
     * @param int $chmod
     * @return array
     */
    public function saveFile($id, $gallery = [], $folder = '', $chmod = 0755) {
        $return = [];
        $folder = $folder ? $folder : config('app.controller');
        $dirPath = str_finish(config('upload.' . $folder), '/');
        $cachePath = str_replace('/777/', '/pic/', $dirPath);
        
        if (!$dirPath or $dirPath == '/') {
            die(trans('language.upload directory is not set in config file'));
        }

        $isGallery = false;
        foreach ($gallery as $key => $value) {
            if (!is_object($value)) {
                $isGallery = true;
            }
        }

        $fileList = (($isGallery or !$gallery) ? Input::file() : $gallery);
        
        $iniFileMaxSize = ini_get('upload_max_filesize');
        $fileMaxMeassureUnit = substr($iniFileMaxSize, -1, 1);
        $fileMaxSize = intval(substr($iniFileMaxSize, 0, strlen($iniFileMaxSize) - 1));

        switch (strtoupper(trim($fileMaxMeassureUnit))) {
        case 'K':
            $fileMaxSize = $fileMaxSize * 1024;
            break;
        case 'M':
            $fileMaxSize = $fileMaxSize * 1024 * 1024;
            break;
        case 'G':
            $fileMaxSize = $fileMaxSize * 1024 * 1024 * 1024;
            break;
        case 'T':
            $fileMaxSize = $fileMaxSize * 1024 * 1024 * 1024 * 1024;
            break;
        }

        if ($fileList) {
            foreach ($fileList as $formName => $file) {
                if (is_array($file)) {
                    foreach ($file as $fName => $f) {
                        $fileList[$formName . "[{$fName}]"] = $f;
                    }
                }
            }
            foreach ($fileList as $formName => $file) {
                if (!is_object($file)) {
                    continue;
                }

                if ($file->isValid()) {
                    $return[$formName]['name'] = $file->getClientOriginalName();
                    $return[$formName]['ext'] = $file->getClientOriginalExtension();
                    $return[$formName]['size'] = round($file->getSize() / 1024);
                    $return[$formName]['mimetype'] = $file->getMimeType();
                    if ($file->getSize() > $fileMaxSize) {
                        die(trans('language.the uploaded file exceeds the upload_max_filesize directive in php.ini'));
                    }
                    preg_match('/(^\/)|(\.\.)|(\[\d*\])/', $formName, $match);
                    if ($match) {
                        continue;
                    }

                    preg_match('/(\w+)\/*(.*)/', $formName, $file_match);
                    preg_match('/([A-Za-z0-9_\-]*)\[(\w*\d*)\]/', $formName, $gallery_match);
                    preg_match('/(^secure)\/*(.*)/',$formName,$secure_match);
                    if($secure_match && $formName == $secure_match[0]){
                        
                        $destnation = str_finish(storage_path('app/secure'),'/') . str_finish(config('app.controller'),'/'). (@$secure_match[2] ? $secure_match[2] . '/' : '');
                       
                        if (!is_dir($destnation)) {
                            File::makeDirectory($destnation, $chmod, true);
                        }

                        $file->move($destnation, $id);
                        $return[$formName]['id'] = $id;
                        $return[$formName]['galleryfile'] = false;    
                    }
                    elseif ($formName == $file_match[0] and !$gallery_match) {
                        if (!$dirPath) {
                            die(trans('language.upload directory is not set in config file'));
                        }
                        $destnation = $dirPath . (@$file_match[2] ? $file_match[2] . '/' : '');
                       
                        if (!is_dir($destnation)) {
                            File::makeDirectory($destnation, $chmod, true);
                        }

                        //## remove cache directory
                        File::deleteDirectory($cachePath . (@$file_match[2] ? $file_match[2] . '/' : '') . $id, true, true);
                        $file->move($destnation, $id);
                        $return[$formName]['id'] = $id;
                        $return[$formName]['galleryfile'] = false;
                    } elseif ($gallery_match) {
                        preg_match('/([A-Za-z0-9_\-]*)\[(\w*\d*)\]/i', $formName, $pic);
                       
                        if ($pic[1] == 'nameList') {
                            $imgId = ($pic[2] != 'id' ? $pic[2] : '') . $id;
                            $destnation = $dirPath;
                        } else {
                            $imgId = @$gallery[$pic[2]];
                            if (!$imgId) {
                                continue;
                            }

                            $destnation = $dirPath . @$pic[1] . '/';
                        }

                        if (!is_dir($destnation)) {
                            File::makeDirectory($destnation, $chmod, true);
                        }

                        //## remove cache directory
                        File::deleteDirectory($cachePath . (@$pic[1] ? @$pic[1] . '/' : '') . $imgId, true, true);
                        $file->move($destnation, $imgId);
                        $return[$formName]['id'] = $imgId;
                        $return[$formName]['galleryfile'] = true;
                    }
                }
            }
        }
        return $return;
    }

    /**
     * get section title
     * @return mixed
     */
    public function getSectionTitle() {
        return '';
    }

    protected function addNullToArray($array){
        $array['']='';
        return $array;
    }
}