<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Video;
use Request;
use FarsiLib;
use Config;
use Input;
use File;
use View;
use Str;

class VideoController extends BackendController {
    public $title = "video";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/video/\' . $item["xvideoid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xvideo_title"];', 'name' => trans('language.title'), 'css' => 'width: 5%', 'sortable' => 'xvideo_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xvideo_desc"],25);', 'name' => trans('language.text'), 'css' => 'width: 10%', 'sortable' => 'xvideo_desc');
        $this->field[] =  array('php' => 'echo $item["xvideo_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xvideo_rank');
    
        $this->list = Video::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'video';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Video::first($id);
        $this->layout->content->imgExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        $this->layout->content->homeimgExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/home/$id");
        $this->layout->title = 'video';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');

        if(Input::file('video/video1')){
            $name = Input::file('video/video1')->getClientOriginalName();
            $size = Input::file('video/video1')->getSize();

        $frm['xfile_name'] = $name;
        $frm['xfile_size'] = $size;
        } 

        if(Input::file('video/video2')){
            $videoname = Input::file('video/video2')->getClientOriginalName();
            $videosize = Input::file('video/video2')->getSize();

        $frm['xvideo_name'] = $videoname;
        $frm['xvideo_size'] = $videosize;
        }
        
        $id = Video::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Video::remove($id);
            File::delete(Config::get('upload.' . Config::get('app.controller')) . "/$id");
            File::delete(Config::get('upload.' . Config::get('app.controller')) . "/home/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(Config::get('upload.' . Config::get('app.controller'))  . "/$id");
        File::delete(Config::get('upload.' . Config::get('app.controller'))  . "/home/$id");
        die('[[OK]]');
    }
}