<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Transaction;
use Input;
use File;
use View;

class TransactionController extends BackendController {
    public $title = 'transaction';

    /**
     * List
     */
    public function index()
    {
        $this->field[] = ['php' => 'echo \'<div class="text-center latin">\' . convertDigit($item["xauthority"]) . "</div>";', 'name' => t('tracking code'), 'css' => 'width: 5%', 'sortable' => 'xauthority'];
        $this->field[] = ['php' => 'echo \'<div class="text-center ">\' . convertDigit($item["xfullname"]) . "</div>";', 'name' => trans('language.full name'), 'css' => 'width: 5%', 'sortable' => 'xfullname'];      
        $this->field[] = ['php' => 'echo \'<div class="text-center"> \' . FarsiLib::faNormalizeNumber((int) $item["xamount"]) . "</div>";', 'name' => t('amount') . ' (' . t('toman') . ')', 'css' => 'width: 5%', 'sortable' => 'xamount'];
        $this->field[] = ['php' => 'echo \'<div class="text-center ltr"> \' . FarsiLib::g2jDate(@$item["created_at"], "Y/m/d") . "</div>";', 'name' => @t('language.time'), 'css' => 'width: 5%', 'sortable' => 'xamount'];
        $this->field[] = ['php' => 'if($item["xstatus"] == 0 && @$item["xstatus"] !== "" ){ echo \'<div class="text-center transaction-status success">\' . @t("successful transactions") . "</div>"; } else { echo \'<div class="text-center transaction-status error">\' . @t("transaction failed"). "</div>"; }', 'name' => trans('language.status'), 'css' => 'width: 2%', 'sortable' => 'xstatus'];

        $this->list = Transaction::getResult()
            ->orderBy('t.created_at', 'desc');
        $this->paginate();

        $this->layout->toolbar['hideCreate'] = true;
        $this->layout->content->listBtn['hideDelete'] = true;
    }

    /**
     * Create
     * @param $id
     */
    public function create($id = 0)
    {
    }

    /**
     * Edit
     * @param $id
     */
    public function edit($id)
    {
        $this->layout->content->list = Transaction::first($id);
    }

    /**
     * Store
     * @param $id
     */
    public function store($id)
    {    
        return abort(403);
    }

    /**
     * Delete
     * @param $id
     */
    public function delete($id)
    {
        return abort(403);
    }

    /**
     * setCombo
     */
    public function setCombo()
    {
        $this->layout->editBtn['hideSubmit'] = true;
    }
}