<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Subscribe;
use App\Models\SystemMsg;
use Config;
use Input;
use Mail;

class SystemMsgController extends BackendController {
    public $title = "systemmsg";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["xsystem_msg_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xsystem_msg_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xsystem_msg_text"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xsystem_msg_text');
        $this->field[] =  array('php' => 'echo $item["xsystem_msg_date"];', 'name' => trans('language.date'), 'css' => 'width: 10%', 'sortable' => 'xsystem_msg_date');

        $this->list = SystemMsg::getResult();
        $this->paginate();
        $this->layout->content->listBtn['sendEmail'] = true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'systemmsg';
    }

    //## edit
    public function edit($id = 0)
    {
        $this->layout->content->list = SystemMsg::first($id);
        $this->layout->title = 'systemmsg';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');

        $id = SystemMsg::store($frm, $id);
        die('[[OK]]');
    }

  //## send
     public function sendEmail($id) 
     {
        $frm = Input::get('frm');

        $emails = SystemMsg::getEmail($id)
            ->where('xsubscribe_status', 'active')
            ->lists('xsubscribe_email');

        foreach ($emails as $email) {
            $data = [
                'email' => $email, 
                'title' => $frm['xsystem_msg_title'], 
                'massage' => $frm['xsystem_msg_text']
            ];

            Mail::send('admin.partial.sendMessge', $data, function($message) use ($data)
            {
                $message->from("info@aghigh.com", 'Site Manager');
                $message->to($data['email'])->subject($data['title']);
            });            
        }
        
        die('[[OK]]');
    }


    //## delete
     public function delete($id)
    {
        if ($id) {
            $res = SystemMsg::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }
}