<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\ShopGuide;
use Config;
use Input;
use File;
use Str;
use App;

class ShopGuideController extends BackendController {
    public $title = "Shopguide";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["xshopguide_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xshopguide_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xshopguide_desc"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xshopguide_desc');
        $this->field[] =  array('php' => 'echo $item["xshopguide_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xshopguide_rank');
    
        $this->list = ShopGuide::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'Shopguide';
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = ShopGuide::first($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'Shopguide';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xshopguide_lang'] = App::getLocale();

        $id = ShopGuide::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = ShopGuide::remove($id);
            File::delete(config('upload.' . config('app.controller')) . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }
}