<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Service;
use Config;
use Input;
use File;
use Str;
use App;

class ServiceController extends BackendController {
    public $title = "service";

    //## list
    public function index()
    {
        // $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/service/\' . $item["xserviceid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
        //    'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xservice_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xservice_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xservice_desc"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xservice_desc');
        $this->field[] =  array('php' => 'echo $item["xservice_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xservice_rank');
    
        $this->list = Service::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'service';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Service::first($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'service';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xservice_lang'] = App::getLocale();

        $id = Service::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Service::remove($id);
            File::delete(config('upload.' . config('app.controller')) . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }
}