<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\SendMethod;
use Config;
use Input;
use File;
use Str;
use App;

class SendMethodController extends BackendController {
    public $title = "send method";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/sendmethod/\' . $item["xsend_methodid"] . "w49h30c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo \'<div class="text-center"> \' . FarsiLib::faNormalizeNumber($item["xsend_method_price"]) . "</div>";', 'name' => t('price') . ' (' . t('toman') . ')', 'css' => 'width: 10%', 'sortable' => 'xsend_method_price');
        $this->field[] =  array('php' => 'echo $item["xsend_method_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xsend_method_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xsend_method_summary"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xsend_method_summary');
        $this->field[] =  array('php' => 'echo $item["xsend_method_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xsend_method_rank');
    
        $this->list = SendMethod::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'send method';
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = SendMethod::first($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'send method';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xsend_method_lang'] = App::getLocale();
        $frm['xsend_method_price'] = str_replace(',', '', $frm['xsend_method_price']);

        $id = SendMethod::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = SendMethod::remove($id);
            File::delete(config('upload.' . config('app.controller')) . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }
}