<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\News;
use Config;
use Input;
use File;
use Str;
use App;

class NewsController extends BackendController {
    public $title = "news";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/news/\' . $item["xnewsid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xnews_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xnews_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xnews_desc"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xnews_desc');
        $this->field[] =  array('php' => 'echo $item["xnews_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xnews_rank');
    
        $this->list = News::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'news';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = News::first($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'news';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xnews_lang'] = App::getLocale();

        $id = News::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = News::remove($id);
            File::delete(config('upload.' . config('app.controller')) . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }
}