<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Group;
use Input;
use File;
use App;


class GroupController extends BackendController {
    public $title = "group";

    //## list
	public function index()
	{
		$this->field[] =  array('php' => 'echo $item["xmodelgroup_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xmodelgroup_title');
        $this->field[] =  array('php' => 'echo $item["xmodelgroup_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xmodelgroup_rank');
    

        $this->list = Group::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Group::first($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');

        $frm['xmodelgroup_lang'] = App::getLocale();

        $id = Group::store($frm, $id);
        //$this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Group::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## set combo
    public function setCombo()
    {
        
    } 
}