<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\GalleryImage;
use App\Models\Gallery;
use Config;
use Input;
use File;
use App;

class GalleryController extends BackendController {
    public $title = "gallery";

    //## list
	public function index()
	{

        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/gallery/\' . $item["xgalleryid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
		$this->field[] =  array('php' => 'echo $item["xgallery_title"];', 'name' => @t('title'), 'css' => 'width: 10%', 'sortable' => 'xgallery_title');
        


        $this->list = Gallery::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having)
            ->orderBy('xid','desc');

        $this->paginate();     
        $this->layout->content->listBtn['showGallery'] = true;
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Gallery::first($id);
        $this->layout->content->imageExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xgallery_lang'] = App::getLocale();

         
        $id = Gallery::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Gallery::remove($id);
            File::delete(config('upload.' . config('app.controller')) . "/$id");

            $galleryid = GalleryImage::getResult()->where('xgalleryid', $id)->lists('xgalleryimageid');
            GalleryImage::remove("xgalleryid = " . $id);
            foreach ($galleryid as $gId) {
                File::delete(Config::get('upload.' . Config::get('app.controller')) . "/gallery/$gId");
            }

            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete Image
    public function deleteImage($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    
    public function editGallery($id)
    {
        $this->layout->storeMethod = 'storeGallery';
        $this->layout->content = view('admin.edit.galleryImage');

        $galleryList = GalleryImage::getResult()->where('xgalleryid', $id)->orderBy('xgalleryimageid')->get();
        $this->layout->content->galleryList = $galleryList ?: [1];
        $this->layout->content->imageExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        foreach ($galleryList as $gallery) {
            $this->layout->content->galleryExist[$gallery['xgalleryimageid']] = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/gallery/" . $gallery['xgalleryimageid']);
        }
        $this->layout->title = '';
    }

    public function storeGallery($id)
    {
        $frm = Input::get('frm');
        $galleryList = Input::get('galleryList');
        $galleryImg = [];
        if ($galleryList) {
            foreach ($galleryList as $key => $gallery) {
                $gallery['xgalleryid'] =  $id;
                $galleryid = GalleryImage::store($gallery, $gallery['xgalleryimageid']);
                $galleryImg[$key] = $galleryid;
            }
        }
        $this->saveFile( $id , $galleryImg);

        die('[[OK]]');
    }

    public function deleteGallery($id){
        if ($id) {
            $res = GalleryImage::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                File::delete(Config::get('upload.' . Config::get('app.controller')) . "/gallery/$id");
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }
}