<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\EquipmentGroup;
use Request;
use FarsiLib;
use Config;
use Input;
use File;
use View;

class EquipmentGroupController extends BackendController {
    public $title = "equipmentgroup";

    //## list
    public function index()
    {

        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/equipmentgroup/\' . $item["xequipmentgroupid"] . "w30h40c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xequipmentgroup_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xequipmentgroup_title');
        $this->field[] =  array('php' => 'echo $item["xequipmentgroup_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xequipmentgroup_rank');
    

        $this->list = EquipmentGroup::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'equipmentgroup';
    }

    //## edit
    public function edit($id)    {

        $this->layout->content->list = EquipmentGroup::first($id);
        $this->layout->content->logoExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        $this->layout->title = 'equipmentgroup';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');

        $id = EquipmentGroup::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = EquipmentGroup::remove($id);
            File::delete(Config::get('upload.' . Config::get('app.controller')) . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteLogo($id)
    {
        File::delete(Config::get('upload.' . Config::get('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        ## get status list
        $statusList = EquipmentGroup::fetchEnum('xequipmentgroup_status');
        $this->layout->statusList = $this->layout->content->statusList = $statusList;
        
    }
}