<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\EquipmentGroup;
use App\Models\Equipment;
use Input;
use File;
use App;

class EquipmentController extends BackendController {
    public $title = "equipment";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/equipment.image/\' . $item["xequipmentid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xequipmentgroup_title"];', 'name' => @t('equipmentgroup'), 'css' => 'width: 10%', 'sortable' => 'xequipmentgroup_title');
        $this->field[] =  array('php' => 'echo $item["xequipment_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xequipment_title');
        $this->field[] =  array('php' => 'echo $item["xequipment_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xequipment_rank');
            

        $this->list = Equipment::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->equipmentList = [1];
        $this->layout->title = 'equipment';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Equipment::first($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) ."/image". "/$id");
        $this->layout->content->bannerExist = File::exists(config('upload.' . config('app.controller')) ."/banner". "/$id");
        $this->layout->title = 'equipment';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xequipment_lang'] = App::getLocale();

        $id = Equipment::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Equipment::remove($id);
            File::delete(config('upload.' . config('app.controller'))  . "/image/$id");
            File::delete(config('upload.' . config('app.controller')) . "/banner/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(config('upload.' . config('app.controller'))  ."/".$type . "/$id");
        die('[[OK]]');
    }

 
    //## set combo
    public function setCombo()
    {
        
        $groups = EquipmentGroup::getResult()->lists('xequipmentgroup_title','xequipmentgroupid');
        $this->layout->groupsList = $this->layout->content->groupsList = $groups; 
     
    }
}