<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Employment;
use Input;
use App;

class EmploymentController extends BackendController {
    public $title = "employment";

    //## list
	public function index()
	{
		$this->field[] =  array('php' => 'echo $item["xemployment_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xemployment_title');
        $this->field[] =  array('php' => 'echo $item["xemployment_expire"];', 'name' => @t('expire'), 'css' => 'width: 10%', 'sortable' => 'xemployment_expire');
    

        $this->list = Employment::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having)
            ->orderBy('xid','desc');
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Employment::first($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xemployment_lang'] = App::getLocale();

        $id = Employment::store($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Employment::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }


    //## set combo
    public function setCombo()
    {
        
    }
}