<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Certificate;
use Config;
use Input;
use File;
use Str;
use App;

class CertificateController extends BackendController {
    public $title = "certificate";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/certificate/\' . $item["xcertificateid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xcertificate_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xcertificate_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xcertificate_desc"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xcertificate_desc');
        $this->field[] =  array('php' => 'echo $item["xcertificate_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xcertificate_rank');
    
        $this->list = Certificate::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'certificate';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Certificate::first($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'certificate';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['xcertificate_lang'] = App::getLocale();

        $id = Certificate::store($frm, $id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Certificate::remove($id);
            File::delete(config('upload.' . config('app.controller')) . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }
}