<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Models\Catalog;
use Config;
use File;
use App;
use Input;

class CatalogController extends BackendController {
    public $title = "catalog";

    //## list
	public function index()
	{

        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/catalog/\' . $item["xcatalogid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
		$this->field[] =  array('php' => 'echo $item["xcatalog_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xcatalogs_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xcatalog_desc"],25);', 'name' => trans('language.description'), 'css' => 'width: 10%', 'sortable' => 'xcatalog_desc');
        $this->field[] =  array('php' => 'echo $item["xcatalog_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xcatalogs_rank');
    

        $this->list = Catalog::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'catalog';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Catalog::first($id);
        $this->layout->content->imgExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        $this->layout->content->fileExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/file/$id");
        $this->layout->title = 'catalog';
    }

    //## store
    public function store($id , $extera = null)
    {
        $frm = Input::get('frm');

         $frm['xcatalog_lang'] = App::getLocale();

        $id = Catalog::store($frm, $id);
        $res = $this->saveFile($id);
  
        if ($res) {
            foreach ($res as $key => $value) {
                if ($key == 'file/file') {
                    $data = array('xfile_size' => $value['size'] ,'xfile_name' => $value['name'] ); 
                    // self::store($data,$id);
                    $id = Catalog::store($data, $id);
                }
            }
        }
        die('[[OK]]');
    }



    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Catalog::remove($id);
            File::delete(Config::get('upload.' . Config::get('app.controller')) . "/$id");
            File::delete(Config::get('upload.' . Config::get('app.controller')) ."/file" . "/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(Config::get('upload.' . Config::get('app.controller'))  . "/$id");
        die('[[OK]]');
    }

     public function deleteFile($id)
    {
        $type = Input::get('type');
        File::delete(Config::get('upload.' . Config::get('app.controller')) ."/". $type . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {   

    }
}