<?php

namespace App\Entities;

use Illuminate\Container\Container;
use Illuminate\Support\Str;

class Permission {

    /**
     * The module name.
     *
     * @var
     */
    protected $module;

    /**
     * The controller name.
     *
     * @var
     */
    protected $controller;

    /**
     * The action name.
     *
     * @var string
     */
    protected $action;

    /**
     * The action name.
     *
     * @var string
     */
    protected $type;

    /**
     * The constructor.
     *
     * @param Container $app
     * @param $name
     * @param $path
     */
    public function __construct($module, $controller, $action) {
        $this->module = $module;
        $this->controller = $controller ?: $this->module;
        $this->action = $action ?: 'index';
    }

    /**
     * Get Module.
     *
     * @return string
     */
    public function getModule() {
        return $this->module;
    }

    /**
     * Set Module.
     *
     * @param string $Module
     *
     * @return $this
     */
    public function setModule($module) {
        $this->module = $module;

        return $this->module;
    }

    /**
     * Get Controller.
     *
     * @return string
     */
    public function getController() {
        return $this->controller;
    }

    /**
     * Set Controller.
     *
     * @param string $Controller
     *
     * @return $this
     */
    public function setController($controller) {
        $this->controller = $controller;

        return $this->controller;
    }

    /**
     * Get Action.
     *
     * @return string
     */
    public function getAction() {
        return $this->action;
    }

    /**
     * Set Action.
     *
     * @param string $Action
     *
     * @return $this
     */
    public function setAction($action) {
        $this->action = $action;

        return $this->action;
    }

    /**
     * Get Type.
     *
     * @return string
     */
    public function getType() {
        return $this->type;
    }

    /**
     * Set Type.
     *
     * @param string $Type
     *
     * @return $this
     */
    public function setType($type) {
        $this->type = $type;

        return $this->type;
    }

    /**
     * Get a specific data from json file by given the key.
     * @return mixed
     */
    public function get() {
        return array(
            'module' => $this->module,
            'controller' => $this->controller,
            'action' => $this->action,
            'type' => $this->type,
        );
    }

    public function isAvailable($value) {
        if ($this->module && $value->xmodule == $this->module) {
            if ($value->xcontroller == $this->controller || $value->xcontroller == 'any') {
                if ($value->xaction == 'block') {
                    return false;
                }
                if ($value->xaction == $this->action || $value->xaction == 'any') {
                    return true;
                }
                if($this->action == 'index'){
                    if($value->xaction == 'store' || $value->xaction == 'edit' || $value->xaction == 'create' || $value->xaction == 'delete')
                        return true;
                }
                if($this->action == 'edit'){
                    if($value->xaction == 'store' || $value->xaction == 'delete')
                        return true;
                }
                if($this->action == 'store'){
                    if($value->xaction == 'create')
                        return true;
                }
            }
        } else {
            return false;
        }
    }

    /**
     * Handle call __toString.
     *
     * @return string
     */
    public function __toString() {
        return $this->module . '-' . $this->controller . '-' . $this->action;
    }

}
