@section('content')

@if(session()->has('status'))
@if(session()->get('status') == 1)
<div class="alert alert-custom alert-success fade show p-2" role="alert">
    <div class="alert-icon ml-4"><i class="flaticon2-check-mark"></i></div>
    <div class="alert-text">اطلاعات شما با موفقیت ثبت شد.</div>
    <div class="alert-close">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true"><i class="ki ki-close"></i></span>
        </button>
    </div>
</div>
@else
<div class="alert alert-custom alert-danger fade show p-2" role="alert">
    <div class="alert-icon ml-4"><i class="flaticon2-cancel-music"></i></div>
    <div class="alert-text">اشکال در ثبت اطلاعات. لطفا دوباره تلاش نمائید</div>
    <div class="alert-close">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true"><i class="ki ki-close"></i></span>
        </button>
    </div>
</div>
@endif
@endif

<div class="card card-custom">
    <div class="card-body p-0">
        <div class="wizard wizard-1" data-type="wizard" data-wizard-state="first" data-wizard-clickable="true">
            <!--begin::Wizard Nav-->
            <div class="wizard-nav border-bottom">
                <div class="wizard-steps p-8 p-lg-10">
                    @var('wizardCounter',0)
                    @foreach($fields as $field)
                        @if(@$field['type'] == 'wizard')
                            @if($wizardCounter++)
                                {{ Metronic::getSVG("admin/media/svg/icons/Navigation/Arrow-left.svg", "svg-icon-xl wizard-arrow") }}
                            @endif
                            
                            <div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
                                <div class="wizard-label">
                                    {{ Metronic::getSVG($field['icon'], "svg-icon-4x wizard-icon") }}
                                    <h3 class="wizard-title">{{$field['text']}}</h3>
                                </div>
                            </div>
                        @endif
                    @endforeach
                    
                </div>
            </div>
            <!--end::Wizard Nav-->
            <!--begin::Wizard Body-->
            <div class="row justify-content-center my-10 px-8 my-lg-15 px-lg-10">
                <div class="col-xl-12 col-xxl-7">
                    <!--begin::Form Wizard-->
                    <form class="form fv-plugins-bootstrap fv-plugins-framework" enctype="multipart/form-data" id="editDataAutomatic" accept-charset="UTF-8" action="{{Lib::getCurrentURL('controller') . '/' . (@$storeMethod ? $storeMethod:  'store') . '/' . config('app.id')}}" novalidate="novalidate" method="POST">
                       @csrf
                        @foreach($fields as $field)
                        <!--begin::Step -->
                        <div class="pb-5" data-wizard-type="step-content" data-wizard-state="current">
                            <div class="row">
                                <div class="col-xl-12">
                                    
                                    @include('newadmin.layout.base._formBuild',['params' => @$field['items'],'values' => @$values, 'pagewidget_id' => 0, 'section' => 'frm', 'vertical' => true])
                                </div>
                            </div>
                        </div>
                        <!--end::Step -->
                        @endforeach
                        
                        <!--begin::Actions-->
                        <div class="d-flex justify-content-between border-top mt-5 pt-10">
                            <div class="ml-2">
                                <button type="button" class="btn btn-light-primary font-weight-bolder text-uppercase px-9 py-4" data-wizard-type="action-prev">مرحله قبل</button>
                                
                            </div>
                            <div>
                                <button type="button" class="btn btn-success font-weight-bolder text-uppercase px-9 py-4" data-wizard-type="action-submit" data-action="validateForm">تائید</button>
                                <button type="button" class="btn btn-primary font-weight-bolder text-uppercase px-9 py-4" data-wizard-type="action-next">مرحله بعدی</button>
                            </div>
                        </div>
                        <!--end::Actions-->
                    <div></div><div></div><div></div></form>
                    <!--end::Form Wizard-->
                </div>
            </div>
            <!--end::Wizard Body-->
        </div>
    </div>
</div>
@endsection