<?php namespace Modules\Tracking\Models;

use App\Classes\Theme\Metronic;
use App\Models\Model;
use Modules\Account\Models\UserInfo;
use DB;

class Tracking extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'btl_tracking';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    
    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'agent_id' => 'int',
        'user_id' => 'int',
        
    ];

    public static $typeList = [0=>'جهت اقدام', 1=> 'انجام شده',  2 => 'عدم تمایل'];
    public static $statusList = [
        0 => "ایجاد ارتباط",
        1 => "برگزاری جلسه",
        2 => "ارسال کاتالوگ الکترونیکی",
        3 => "ارسال کاتالوگ فیزیکی",
        4 => "ارسال نمونه",
        5 => "ارائه قیمت",
        6 => "رصد مشتری",
        7 => "ارسال پیش فاکتور",
        8 => "بازگشت نمونه",
        9 => "نهایی سازی سفارش",
        10 => "پیش پرداخت",
        11 => "آماده سازی محصول",
        12 => "ارسال محصول",
        13 => "ارسال فاکتور",
        14 => "تسویه حساب",
        15 => "نامه رضایت"
    ];

    public function agent() {
        return $this->belongsTo(Agent::class, 'agent_id');
    }

    public function user() {
        return $this->belongsTo(UserInfo::class, 'user_id');
    }

    public function field() {
        return $this->belongsTo(Field::class, 'field_id');
    }

    public function status() {
        return $this->belongsTo(TrackingStatus::class, 'status_id');
    }

    public function type() {
        return $this->belongsTo(TrackingType::class, 'type_id');
    }


    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS t")
            ->leftJoin('btl_agent AS a', 't.agent_id', '=', 'a.id')
            ->leftJoin('btl_company AS c', 'a.company_id', '=', 'c.id')
            ->leftJoin('xxsecurity_userinfo AS u', 't.user_id', '=', 'u.xuserid')
            ->leftJoin(DB::raw("(" . self::arrayToSqlTable(self::$typeList) . ")AS typeList"),'typeList.id','=','t.type')
            ->leftJoin(DB::raw("(" . self::arrayToSqlTable(self::$statusList) . ")AS statusList"),'statusList.id','=','t.status')
            ->select(['t.*','u.*', "t.{$instance->primaryKey} AS xid", DB::raw("CONCAT(COALESCE(a.name,''),' ',COALESCE(a.family,'')) AS agent_name"), "c.name AS company_name","typeList.name AS type_name","statusList.name AS status_name"]);
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}