<?php namespace Modules\Tracking\Models;

use App\Models\Model;
use DB;

class Group extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'btl_group';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'parent_id' => 'int',
    ];

    public function parent() {
        return $this->hasOne(Group::class, 'id', 'parent_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS g")
            ->leftJoin('btl_group AS gp', 'g.parent_id', '=', 'gp.id')
            ->select(['g.*', "g.{$instance->primaryKey} AS xid", "gp.name AS parent_name"]);
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}