<?php namespace Modules\Tracking\Models;

use App\Models\Model;
use Modules\Tracking\Models\Group;
use DB;

class Company extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'btl_company';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'group_id' => 'int',
        'type' => 'int',
    ];

    public static $levelList = [1=>'درجه 1', 2=> 'درجه 2',  3 => 'درجه 3', 4 => 'درجه 4'];

    public function group() {
        return $this->hasOne(Group::class, 'id', 'group_id');
    }

    public function agents() {
        return $this->hasMany(Agent::class);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        //(SELECT c.id AS companyID,date,c.name,c.group_id,c.acquaint_id,c.level, g.name AS group_name,levelList.name as level_name,typeList.name AS type_name, statusList.name AS status_name
        //LEFT JOIN (select * from btl_view_agenttrack where IFNULL(DATE,"") in (select IFNULL(MAX(DATE),"") as mdate from btl_view_agenttrack GROUP BY company_id)) as at  ON c.id = at.company_id
        $res = DB::table(DB::raw('
        
        (SELECT c.id AS companyID,c.name,c.group_id,c.acquaint_id,c.level, g.name AS group_name,levelList.name as level_name
        FROM btl_company AS c
        LEFT JOIN btl_group AS g ON g.id = c.group_id
       '.
        " LEFT JOIN (".self::arrayToSqlTable(self::$levelList).")AS levelList ON levelList.id = c.level " .
        //" LEFT JOIN (".self::arrayToSqlTable(Tracking::$typeList).")AS typeList ON typeList.id = at.type " .
        //" LEFT JOIN (".self::arrayToSqlTable(Tracking::$statusList).")AS statusList ON statusList.id = at.status " .
        ") AS tt "))
        // ->where(DB::raw('IFNULL(tt.date,"")'),DB::raw(
        // '(
        //     SELECT IFNULL(MAX(DATE),"") AS mdate
        //     FROM btl_company
        //     left JOIN btl_agent ON btl_agent.company_id = btl_company.id
        //     left JOIN btl_tracking ON btl_agent.id = btl_tracking.agent_id
        //     WHERE tt.companyID = btl_company.id
        //     GROUP BY btl_company.id
        // )
        // '))
        //->orderBy('tt.date','desc')
        ->groupBy('companyID')
        ->select(['*', "tt.companyID AS xid", DB::raw('tt.*')]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}