<?php namespace Modules\Tracking\Models;

use App\Models\Model;
use DB;

class Agent extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'btl_agent';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'company_id' => 'int',
    ];

    public function company() {
        return $this->hasOne(Company::class, 'id', 'company_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS a")
            ->leftJoin('btl_company AS c', 'a.company_id', '=', 'c.id')
            ->leftJoin('btl_jobposition AS jp', 'a.jobposition_id', '=', 'jp.id')
            ->leftJoin('btl_jobtitle AS jt', 'a.jobtitle_id', '=', 'jt.id')
            ->select(['a.*', "a.{$instance->primaryKey} AS xid", "c.name AS company_name", "jp.name AS jobposition_name", "jt.name AS jobtitle_name"]);
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}