<?php namespace Modules\Tracking\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Tracking\Models\Agent;
use Modules\Tracking\Models\Company;
use Modules\Tracking\Models\Tracking;
use Modules\Tracking\Models\Acquaint;
use Modules\Tracking\Models\Group;
use Modules\Tracking\Models\Field;
use Modules\Account\Models\User;
use DB;
use Auth;
use Modules\Account\Models\ItemPermission;
use Modules\Tracking\Models\TrackingType;
use Illuminate\Support\Carbon;

class TrackingController extends BackendController {

    public $title = "tracking";

    function __construct(){
        $this->model = Tracking::with(['status','field','type']);
            // leftJoin('btl_tracking_status as status','status.id','=','status_id')
            // ->leftJoin('btl_field as field','field.id','=','field_id')
            // ->leftJoin('btl_tracking_type as type','type.id','=','type_id');
        parent::__construct();
    }

    protected $scaffold = [
        'checkbox' => true,
        'footerSum' => false
    ];

    protected  $fields = [

        'agent_id' => [
            'name' => 'agent',
            'listView' => true,
            'searchView' => true,
            'text' => 'رابط',
            'orderable' => true,
            'type' => 'dynamicComboBox',
            'value' => 'family'
        ],
        'field_id' => [
            'name' => 'field',
            'listView' => true,
            'searchView' => true,
            'text' => 'حوزه',
            'orderable' => true,
            'type' => 'dynamicComboBox',
            'value' => 'name'
        ],
        'status_id' => [
            'name' => 'status',
            'listView' => true,
            'searchView' => true,
            'text' => 'وضعیت',
            'orderable' => true,
            'type' => 'dynamicComboBox',
            'value' => 'name'
        ],
        'description' => [
            'name' => 'description',
            'listView' => true,
            'searchView' => true,
            'text' => 'توضیحات',
            'type' => 'text'
        ],
        'date' => [
            'name' => 'date',
            'listView' => false,
            'searchView' => true,
            'text' => 'تاریخ',
            'type' => 'pdateTime',
            'render' => 'persianDate'
        ],
        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => false,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '140',
        ],


    ];

    //## list
    // public function index() {
    //     $this->field[] = array('php' => 'echo $item["xname"] . " " . $item["xfamily"];', 'name' =>  @t('user'), 'css' => 'width: 10%', 'sortable' => 'user_id');
    //     $this->field[] = array('php' => 'echo $item["company_name"];', 'name' =>  @t('company'), 'css' => 'width: 10%', 'sortable' => 'company_id');
    //     $this->field[] = array('php' => 'echo $item["agent_name"];', 'name' =>  @t('name').' '.@t('agent'), 'css' => 'width: 10%', 'sortable' => 'agent_id');
    //     $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["date"],true);', 'name' => @t('date'), 'css' => 'width: 10%', 'sortable' => 'date');
    //     $this->field[] = array('php' => 'echo $item["type_name"];', 'name' => @t('type'), 'css' => 'width: 10%', 'sortable' => 'type');
    //     $this->field[] = array('php' => 'echo $item["status_name"];', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'status');
    //     $this->field[] = array('php' => 'echo $item["description"];', 'name' => t('description'), 'css' => 'width: 10%', 'sortable' => 'description');

    //     $this->list = Tracking::getResult();
    //     if(Auth::id() != 1)
    //         $this->list->where('user_id',Auth::id());
    //     else{
    //             $this->layout->toolbar['showTools'] = true;
    //         }

    //     $this->paginate();
    //     //$this->layout->toolbar['showTools'] = true;
    //     $this->layout->content->listBtn['showCheckbox'] = true;
    // }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Tracking::find($id);
        $this->layout->title = $this->title;
        
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        if(!$frm['agent_id'])
            die('[[ERROR]]');

        $after = Input::get('after');
        $frm['user_id'] = Auth::id();
        $company = Tracking::updateById($frm, $id);
        
        foreach ($after as $key => $value) {
            if($value['date']){
                $value['user_id'] = $frm['user_id'];
                $value['agent_id'] = @$frm['agent_id'];
                $value['field_id'] = @$frm['field_id'];
                $value['type'] = 0;
                $company = Tracking::updateById($value);
            }
        }
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Tracking::remove($id);
    }

    //## set combo
    public function setCombo() {
        
        $this->layout->typeList = $this->addNullToArray(Tracking::$typeList);
        $this->layout->content->typeList = Tracking::$typeList;
        $this->layout->statusList = $this->addNullToArray(Tracking::$statusList);
        $this->layout->content->statusList = Tracking::$statusList;

        $this->layout->acquaintList = $this->layout->content->acquaintList = Acquaint::pluck('name', 'id')->prepend('','');
        $this->layout->levelList = $this->layout->content->levelList = $this->addNullToArray(Company::$levelList);
        $this->layout->groupList = Group::pluck('name', 'id')->prepend('', '');
        $this->layout->userList = User::pluck('xusername', 'xuserid')->prepend('', '');
        $this->layout->fieldList = $this->layout->content->fieldList = Field::pluck('name', 'id')->prepend('','');
    }

    public function getAgentData(){
        $id = Input::get('id');
        $id = $id ? explode(",",$id) : -1;
        $tracks = Tracking::with(['status','field','type'])->whereIn('agent_id',$id)->orderBy('created_at','dsc')->get();
        $data = [
            "data" => $tracks
        ];

        return response()->json($data, 200);
    }

    public function setAgentData($id){
        $frm = Input::all();
        $frm['user_id'] = Auth::id();
        $track = Tracking::updateById($frm,$id);
        $company = $track->agent->company;
        $lastCache= json_decode($company->cache,true);
        $cache = [
            "lastTracking"=> Carbon::now()->format('Y-m-d H:i:s'), 
            "nextTracking"=> $track->date, 
            "progress"=> $lastCache['progress'] > 95 ? 100 : ($lastCache['progress'] + 5), 
            "lastTrackingText"=> $track->description, 
            "lastStatus"=> $track->status->name, 
            "lastAction"=> $track->type->name, 
            "trackingCount"=> $lastCache['trackingCount'] + 1, 
            "commentCount"=> "150"
        ];

        $company->cache = json_encode($cache);
        $company->save();
        
        return response()->json(['status' => 1],200);
        
    }

    //## update
    public function getAgentInfo($id) {
        $agentid = Input::get('agentid');
        $agent = Agent::find($agentid);
        if($agent){
            $permission = ItemPermission::where('user_id',Auth::id())
                ->where('controllerable_id',$agent->company_id)
                ->where('controller','65')
                ->first();
            if($permission && $permission->type == 6){
                die(json_encode(['type' => 'success', 'message' => trans('language.information successfully updated'),
                'data' => ' تلفن: ' . $agent->tell . ' موبایل: ' . $agent->mobile . ' آدرس: ' . $agent->address]));
            }
        }
        die(json_encode(['type' => 'failed', 'message' => trans('language.information failed updated'),
            'data' => 'اطلاعات تماس یافت نشد.']));
    }


}