<?php namespace Modules\Tracking\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Tracking\Models\Group;
use Modules\Tracking\Models\Field;
use DB;

class FieldController extends BackendController {

    public $title = "field";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["name"];', 'name' => @t('name'), 'css' => 'width: 30%', 'sortable' => 'name');
        $this->field[] = array('php' => 'echo $item["description"];', 'name' => t('description'), 'css' => 'width: 70%', 'sortable' => 'description');
        $this->list = Field::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Field::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $field = Field::updateById($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id) {
        Field::remove($id);
    }

    //## set combo
    public function setCombo() {
        
    }

    

}