<?php namespace Modules\Tracking\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Tracking\Models\Group;
use Modules\Tracking\Models\Company;
use DB;

class CompanyGroupController extends BackendController {

    function __construct(){
        $this->model = Group::where('parent_id',0);
        //newQuery()
    }

    public $title = "group";

    protected $scaffold = [
        'checkbox' => true,
        'footerSum' => false,
        'backButton' => true,
        'dom' => 'folderView',
        'serverSide' => true,
        'pageLength' => 30
    ];

    protected  $fields = [
        'parent_id' => [
            'name' => 'parent_id',
            'listView' => true,
            'searchView' => false,
            'text' => 'والد',
            'orderable' => false,
            'render' => 'folderView',
            'type' => 'number',
            'visible' => 'hidden'
        ],
        'type' => [
            'name' => 'type',
            'listView' => true,
            'searchView' => false,
            'text' => 'نوع',
            'orderable' => false,
            'type' => 'number',
            'visible' => 'hidden'
        ],
        'name' => [
            'name' => 'name',
            'listView' => true,
            'searchView' => true,
            'text' => 'عنوان',
            'orderable' => true,
            'render' => 'folderView',
            'type' => 'text'
        ],
        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => true,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '180px',
        ],


    ];


    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
        $this->layout->content->parentList = Group::pluck('name', 'id')->prepend('بدون والد');
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Group::find($id);
        $this->layout->title = $this->title;
        $this->layout->content->parentList = Group::pluck('name', 'id')->prepend('بدون والد', '')->forget($id);
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $company = Group::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Group::remove($id);

    }

    //## set combo
    public function setCombo() {
        $this->layout->parentList = Group::pluck('name', 'id')->prepend('', '');
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Company::getResult()->orderBy('p1.xcompanyid','asc')->select(["p1.xcompany_title",'p1.xcompany_subtitle','p1.xcompany_desc','p2.xcompany_title as parentName','p1.xcompany_menu','p1.type','p1.xcompany_footer','p1.xstatus',DB::raw("CONCAT('/company/', p1.xcompanyid,'/', REPLACE(p1.xcompany_title,' ','-')) as link")]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('p1.xcompanyid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "p1.xcompanyid",
                "direction" => "desc",
            ]];
        }
        $heading = ['عنوان','زیر عنوان','توضیحات','نام والد','قرارگیری در منو','نوع','قرارگیری در فوتر','وضعیت','لینک'];
        return (new Export($this->list,$heading))->download('companys.xlsx');
    }

}