<?php namespace Modules\Tracking\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Tracking\Models\Group;
use Modules\Tracking\Models\Company;
use Modules\Tracking\Models\Acquaint;
use Modules\Tracking\Models\Agent;
use Modules\Account\Models\ItemPermission;
use Modules\Tracking\Models\JobPosition;
use Modules\Tracking\Models\JobTitle;
use DB;
use Auth;
use Modules\Tracking\Models\Field;
use Modules\Tracking\Models\TrackingStatus;
use Modules\Tracking\Models\TrackingType;

class CompanyController extends BackendController {

    public $title = "company";
    public $typeList = [0 => 'دولتی', 1=>'خصوصی', 2=>'خصولتی'];

    function __construct(){
        $this->model = Company::with('agents');
        parent::__construct();
    }

    protected $scaffold = [
        'listView' => 'project',
        'checkbox' => false,
        'footerSum' => false
    ];

    protected  $fields = [
        'project_detail' => [
            'type' => 'wizard',
            'text' => 'جزئیات مشتری',
            'searchView' => true,
            'icon' => 'admin/media/svg/icons/Communication/Chat-check.svg',
            'items' => [
                'name' => [
                    'name' => 'name',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'نام مشتری',
                    'type' => 'text'
                ],
                'group_id' => [
                    'name' => 'group_id',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'گروه',
                    'orderable' => false,
                    'type' => 'folderList',
                    'fields' => [ 'عنوان'],
                    'relation' => ['controller' => 'CompanyGroup']
                ],
                'level' => [
                    'name' => 'level',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'درجه',
                    'type' => 'iconComboBox',
                    'values' => [
                        1 => ['title' => 'طلایی', 'icon' => 'flaticon2-correct text-warning icon-md ml-1'],
                        2 => ['title' => 'نقره ای', 'icon' => 'flaticon2-correct text-success icon-md ml-1'],
                        3 => ['title' => 'برنزی', 'icon' => 'flaticon2-correct text-secondary icon-md ml-1']
                    ]
                ],
                'type' => [
                    'name' => 'type',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'نوع بنگاه',
                    'type' => 'comboBox',
                    'values' => [
                        1 => 'دولتی',
                        2 => 'خصوصی',
                        3 => 'خصولتی'
                    ]
                ],
                'acquaint_id' => [
                    'name' => 'acquaint_id',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'نحوه آشنایی',
                    'type' => 'comboBox',
                    'relation' => [
                        'class' => Acquaint::class,
                        'fields' => ['name','id']
                    ]
                ],
                'abstract' => [
                    'name' => 'abstract',
                    'listView' => false,
                    'searchView' => false,
                    'text' => 'خلاصه',
                    'type' => 'textarea'
                ],
                'buyer' => [
                    'name' => 'buyer',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'سابقه خرید',
                    'type' => 'switch'
                ],
               
            ]
        ],
        'project_location' => [
            'type' => 'wizard',
            'text' => 'آدرس',
            'icon' => 'admin/media/svg/icons/Home/Globe.svg',
            'items' => [
                'province_id' => [
                    'name' => 'province_id',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'استان',
                    'type' => 'comboBox',
                    'values' => [
                        1 => 'تهران',
                        2 => 'اصفهان',
                        3 => 'شیراز'
                    ]
                ],
                'city_id' => [
                    'name' => 'city_id',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'شهر',
                    'type' => 'comboBox',
                    'values' => [
                        1 => 'تهران',
                        2 => 'هشتگرد',
                        3 => 'کرج'
                    ]
                ],
                'address' => [
                    'name' => 'address',
                    'listView' => false,
                    'searchView' => false,
                    'text' => 'آدرس',
                    'type' => 'textarea'
                ],
                'site' => [
                    'name' => 'site',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'وب سایت',
                    'type' => 'text'
                ],
                'email' => [
                    'name' => 'email',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'پست الکترونیک',
                    'type' => 'text'
                ],
                'tell' => [
                    'name' => 'tell',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'تلفن',
                    'type' => 'text'
                ],
            ]
        ],
        'project_curd' => [
            'type' => 'wizard',
            'text' => 'سطح دسترسی',
            'icon' => 'admin/media/svg/icons/Devices/Display1.svg',
            'items' => [
                
                'accessUsers' => [
                    'name' => 'accessUsers',
                    'text' => 'کاربران',
                    'orderable' => false,
                    'listView' => false,
                    'searchView' => false,
                    'width' => '120px',
                    'type' => 'form',
                    'params' => [
                        'user_id' => [
                            'name' => 'user_id',
                            'text' => 'کاربر',
                            'type' => 'comboBox',
                            'responsive' => [
                                'wrapper' => 'col-6',
                                'label' => 'd-none',
                                'element' => ' '
                            ],
                            'values' =>[
                                1 => 'محسن عاشوری',
                                2 => 'رضا غلامی',
                            ]
                        ],
                        'access' => [
                            'name' => 'access',
                            'text' => 'نوع دسترسی',
                            'type' => 'comboBox',
                            'responsive' => [
                                'wrapper' => 'col-4',
                                'label' => 'd-none',
                                'element' => ' '
                            ],
                            'values' =>[
                                1 => 'مشاهده',
                                2 => 'مشاهده و تغییر',
                                3 => 'حذف',
                            ]
                        ] 
                    ]
                ],
            ]
        ],
        
        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => true,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '120px',
        ],

        'cache' => [
            'name' => 'cache',
            'listView' => true,
            'searchView' => false,
            'text' => 'کش',
            'type' => 'json'
        ],

        'agents' => [
            'name' => 'agents',
            'listView' => true,
            'searchView' => false,
            'text' => 'رابط سازمان',
            'type' => 'elequentRelation'
        ],


    ];

    //## list
    // public function index() {
    //     $this->field[] = array('php' => 'echo $item["name"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'name');
    //     $this->field[] = array('php' => 'echo $item["group_name"];', 'name' =>  @t('group'), 'css' => 'width: 10%', 'sortable' => 'group_name');
    //     $this->field[] = array('php' => 'echo $item["level_name"];', 'name' => @t('level'), 'css' => 'width: 10%', 'sortable' => 'level_name');
    //     //$this->field[] = array('php' => 'echo FarsiLib::g2jdate($item["date"],true);', 'name' => t('date'), 'css' => 'width: 10%', 'sortable' => 'date');
    //     //$this->field[] = array('php' => 'echo $item["type_name"];', 'name' => @t('type'), 'css' => 'width: 10%', 'sortable' => 'type_name');
    //     //$this->field[] = array('php' => 'echo $item["status_name"];', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'status_name');

    //     $this->list = Company::getResult();
    //     if (Auth::id() != 1){
    //         $this->list->leftJoin('xxsecurity_module_permission AS sp','controllerable_id' ,'=' ,'tt.companyId')
    //         ->where('sp.controller','65')
    //         ->where('sp.type',6)
    //         ->where('sp.user_id',Auth::id());
    //     }

    //     $this->paginate();
    //     if (Auth::id() == 1){
    //         $this->layout->toolbar['showTools'] = true;
    //     }
    //     $this->layout->content->listBtn['showCheckbox'] = true;
    //     $this->layout->content->listBtn['showItems'] = true;
    // }

    public function view($id){
        $this->layout->content = view('tracking::admin.project.view',['id' => $id]);
        
    }

    //## new
    public function create($id = 0) {
        $this->layout->content = view('tracking::admin.project.create',[
            'fields' => $this->fields
            ]);
        
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Company::find($id);
        $this->layout->title = $this->title;
        
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $company = Company::updateById($frm, $id);
        $permissions = ItemPermission::updateById(['user_id' => Auth::id(), 'controller' => '65', 'controllerable_id' => $company->id, 'type' => 6]);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Company::remove($id);

    }

    //## set combo
    public function setCombo() {
        //$this->layout->groupList = Group::pluck('name', 'id')->prepend('', '');
        $this->layout->group1List = $this->layout->content->group1List = Group::where('parent_id',0)->pluck('name', 'id')->prepend('', '');
        $groups = Group::where('parent_id','!=',0)->get();
        $groupList = [];
        foreach (@$groups as $key => $val) {
            if (!@$groupList[@$val['id']]) {
                $groupList[@$val['id']][''] = '';
            }
            $groupList[@$val['parent_id']][@$val['name']] = @$val['id'];
        }
        $groupList['']['']='';
        $this->layout->groupList = $this->layout->content->groupList = $groupList;
        $this->layout->statusList = $this->layout->content->statusList = TrackingStatus::pluck('name', 'id')->prepend('','');
        $this->layout->typeList = $this->layout->content->typeList = TrackingType::pluck('name', 'id')->prepend('','');
        $this->layout->fieldList = $this->layout->content->fieldList = Field::pluck('name', 'id')->prepend('','');
        $this->layout->acquaintList = $this->layout->content->acquaintList = Acquaint::pluck('name', 'id')->prepend('','');
        
        // $this->layout->levelList = $this->addNullToArray(Company::$levelList);
        // $this->layout->content->levelList = Company::$levelList;
    }

    public function editItems($id)
    {
        $this->layout->title = 'items';
        $this->layout->storeMethod = 'storeItems';
        $this->layout->content = view('tracking::admin.edit.agentlist');
        $this->layout->content->jobpositionList = JobPosition::pluck('name','id')->prepend('سمت شغلی','');
        $this->layout->content->jobtitleList = JobTitle::pluck('name','id')->prepend('عنوان شغلی','');
        $this->layout->content->genderList = [0 => 'male' , 1 => 'female'];
        $this->layout->content->acquaintList = Acquaint::pluck('name', 'id')->prepend('','');
        
        if (Auth::id() != 1){
            $company =  Company::leftJoin('xxsecurity_module_permission','controllerable_id','=','btl_company.id')
            ->where('xxsecurity_module_permission.controller','65')
            ->where('xxsecurity_module_permission.type',6)
            ->where('xxsecurity_module_permission.user_id',Auth::id())
            ->where('btl_company.id',$id)
            ->count();
            if($company)
                $this->layout->content->company = Company::find($id);
            
        }else{
            $this->layout->content->company = Company::find($id);
        }
      
    }

    public function storeItems($id)
    {
        $frm = Input::get('list');
        $question = Company::find($id);
        
        Agent::syncOneToMany($frm,$id,'company_id');

        die('[[OK]]');
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Company::getResult()->orderBy('p1.xcompanyid','asc')->select(["p1.xcompany_title",'p1.xcompany_subtitle','p1.xcompany_desc','p2.xcompany_title as parentName','p1.xcompany_menu','p1.type','p1.xcompany_footer','p1.xstatus',DB::raw("CONCAT('/company/', p1.xcompanyid,'/', REPLACE(p1.xcompany_title,' ','-')) as link")]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('p1.xcompanyid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "p1.xcompanyid",
                "direction" => "desc",
            ]];
        }
        $heading = ['عنوان','زیر عنوان','توضیحات','نام والد','قرارگیری در منو','نوع','قرارگیری در فوتر','وضعیت','لینک'];
        return (new Export($this->list,$heading))->download('companys.xlsx');
    }

}