<?php namespace Modules\Tracking\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Tracking\Models\Agent;
use Modules\Tracking\Models\Company;
use Modules\Tracking\Models\JobPosition;
use Modules\Tracking\Models\JobTitle;
use Modules\Tracking\Models\Acquaint;
use DB;
use Auth;

class CompanyAgentController extends BackendController {

    public $title = "agent";
    function __construct(){
        $this->model = Agent::query();
        parent::__construct();
    }

    protected $scaffold = [
        'checkbox' => true,
        'footerSum' => false
    ];

    protected  $fields = [
        'project_detail' => [
            'type' => 'wizard',
            'text' => 'جزئیات مشتری',
            'searchView' => true,
            'icon' => 'admin/media/svg/icons/Communication/Chat-check.svg',
            'items' => [
                'name' => [
                    'name' => 'name',
                    'listView' => true,
                    'searchView' => true,
                    'text' => 'نام',
                    'orderable' => true,
                    'type' => 'text',
                    'required' => true
                ],
                'family' => [
                    'name' => 'family',
                    'listView' => true,
                    'searchView' => true,
                    'text' => 'نام خانوادگی',
                    'orderable' => true,
                    'type' => 'text',
                    'required' => true
                ],
                'gender' => [
                    'name' => 'gender',
                    'listView' => true,
                    'searchView' => true,
                    'text' => 'جنسیت',
                    'orderable' => true,
                    'type' => 'radioBox',
                    'required' => true
                ],
                'description' => [
                    'name' => 'description',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'توضیحات',
                    'type' => 'textarea'
                ],
                'acquaint_id' => [
                    'name' => 'acquaint_id',
                    'listView' => true,
                    'searchView' => true,
                    'text' => 'نحوه آشنایی',
                    'orderable' => true,
                    'type' => 'comboBox',
                    'required' => true,
                    'relation' => [
                        'class' => Acquaint::class,
                        'fields' => ['name','id']
                    ]
                ],
                'jobtitle_id' => [
                    'name' => 'jobtitle_id',
                    'listView' => true,
                    'searchView' => true,
                    'text' => 'عنوان شغلی',
                    'orderable' => true,
                    'type' => 'comboBox',
                    'required' => true,
                    'relation' => [
                        'class' => JobTitle::class,
                        'fields' => ['name','id']
                    ]
                ],
                'jobposition_id' => [
                    'name' => 'jobposition_id',
                    'listView' => true,
                    'searchView' => true,
                    'text' => 'سمت شغلی',
                    'orderable' => true,
                    'type' => 'comboBox',
                    'required' => true,
                    'relation' => [
                        'class' => JobPosition::class,
                        'fields' => ['name','id']
                    ]
                ],

            ]
        ],
        
        'project_location' => [
            'type' => 'wizard',
            'text' => 'موقعیت',
            'searchView' => true,
            'icon' => 'admin/media/svg/icons/Home/Globe.svg',
            'items' => [
                'email' => [
                    'name' => 'email',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'ایمیل',
                    'type' => 'text'
                ],
                'social' => [
                    'name' => 'social',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'شبکه های اجتماعی',
                    'type' => 'text'
                ],
                'mobile' => [
                    'name' => 'mobile',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'موبایل',
                    'type' => 'text'
                ],
                'tell' => [
                    'name' => 'tell',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'تلفن',
                    'type' => 'text',
                    'required' => true
                ],
                'inner_tell' => [
                    'name' => 'inner_tell',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'داخلی',
                    'type' => 'text'
                ],
                'fax' => [
                    'name' => 'fax',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'فکس',
                    'type' => 'text'
                ],
                'address' => [
                    'name' => 'address',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'آدرس',
                    'type' => 'textarea'
                ],
                'postal_code' => [
                    'name' => 'postal_code',
                    'listView' => false,
                    'searchView' => true,
                    'text' => 'کد پستی',
                    'type' => 'text'
                ],
            ]
        ],

        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => false,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '140',
        ],


    ];

    //## list
    // public function index() {
    //     $this->field[] = array('php' => 'echo $item["name"]." ".$item["family"];', 'name' => @t('family'), 'css' => 'width: 10%', 'sortable' => 'family');
    //     $this->field[] = array('php' => 'echo $item["company_name"];', 'name' =>  @t('company'), 'css' => 'width: 10%', 'sortable' => 'group_id');
    //     $this->field[] = array('php' => 'echo $item["mobile"];', 'name' => t('mobile'), 'css' => 'width: 10%', 'sortable' => 'mobile');
    //     $this->field[] = array('php' => 'echo $item["tell"];', 'name' => t('tell'), 'css' => 'width: 10%', 'sortable' => 'tell');
    //     $this->field[] = array('php' => 'echo $item["jobposition_name"];', 'name' => t('job position'), 'css' => 'width: 10%', 'sortable' => 'jobposition_name');
    //     $this->field[] = array('php' => 'echo $item["jobtitle_name"];', 'name' => t('job title'), 'css' => 'width: 10%', 'sortable' => 'jobtitle_name');

    //     $this->list = Agent::getResult();
    //     if (Auth::id() != 1){
    //         $this->list->leftJoin('xxsecurity_module_permission','controllerable_id','=','c.id')
    //         ->where('xxsecurity_module_permission.controller','65')
    //         ->where('xxsecurity_module_permission.type',6)
    //         ->where('xxsecurity_module_permission.user_id',Auth::id());
    //     }

    //     $this->paginate();
    //     if (Auth::id() == 1){
    //         $this->layout->toolbar['showTools'] = true;
    //     }
    //     $this->layout->content->listBtn['showCheckbox'] = true;
    // }

    //## new
    public function create($id = 0) {
        $this->layout->content = view('tracking::admin.project.create',[
            'fields' => $this->fields
            ]);
    }

    //## edit
    public function edit($id) {
        $this->layout->content = view('tracking::admin.project.create',[
            'fields' => $this->fields,
            'values' => Agent::find($id)
            ]);
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $agent = Agent::updateById($frm, $id);
        return redirect()->back()->with('status', '1');

    }

    //## delete
    public function delete($id) {
        Agent::remove($id);

    }

    //## set combo
    public function setCombo() {
        $company = Company::leftJoin('xxsecurity_module_permission','controllerable_id','=','btl_company.id')
        ->where('xxsecurity_module_permission.controller','65')
        ->where('xxsecurity_module_permission.type',6)
        ->where('xxsecurity_module_permission.user_id',Auth::id())
        ->pluck('btl_company.name', 'btl_company.id')
        ->prepend('', '');

        $this->layout->companyList = $this->layout->content->companyList = $company;
        $this->layout->jobpositionList = $this->layout->content->jobpositionList = JobPosition::pluck('name','id')->prepend('','');
        $this->layout->jobtitleList = $this->layout->content->jobtitleList = JobTitle::pluck('name','id')->prepend('','');
        $this->layout->genderList = $this->layout->content->genderList = [0 => 'male' , 1 => 'female'];
        $this->layout->acquaintList = $this->layout->content->acquaintList = Acquaint::pluck('name', 'id')->prepend('','');
    }

     /*
   AJAX request
   */
   public function getCustomerAjax(){

    $search = Input::get('search');
    
    if(Auth::id() == 1){
        $company = Company::orderby('name','asc')
        ->whereNotNull('name')
        ->select('btl_company.id','btl_company.name')
        ->limit(20);    
    }else{
        $company = Company::leftJoin('xxsecurity_module_permission','controllerable_id','=','btl_company.id')
        ->where('xxsecurity_module_permission.controller','65')
        ->where('xxsecurity_module_permission.type',6)
        ->where('xxsecurity_module_permission.user_id',Auth::id())
        ->whereNotNull('name')
        ->orderby('name','asc')
        ->groupBy('btl_company.id')
        ->select('btl_company.id','btl_company.name')
        ->limit(20);
    }

    if($search == ''){
       $companies = $company->get();
    }else{
       $companies = $company->where('name', 'like', '%' .$search . '%')->get();
    }

    $response = array();
    foreach($companies as $company){
       $response[] = array(
            "id"=>$company->id,
            "text"=>$company->name
       );
    }

    echo json_encode($response);
    exit;
 }

 public function getAgentAjax(){
     $customerId = Input::get('id');
     
     if(Auth::id() != 1){
        $customer = Company::leftJoin('xxsecurity_module_permission','controllerable_id','=','btl_company.id')
        ->where('xxsecurity_module_permission.controller','65')
        ->where('xxsecurity_module_permission.type',6)
        ->where('xxsecurity_module_permission.user_id',Auth::id())
        ->where('btl_company.id',$customerId)
        ->groupBy('btl_company.id')
        ->count();
    }else{$customer = 1;}
    
    $response = array();
    if($customer){
        $agents = Agent::where('company_id',$customerId)->get();
        foreach($agents as $agent){
            $response[] = array(
                 "id"=>$agent->id,
                 "text"=>$agent->name.' '.$agent->family
            );
         }
    }
    echo json_encode($response);
    exit;
 }

 

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Agent::getResult()->orderBy('p1.xcompanyid','asc')->select(["p1.xcompany_title",'p1.xcompany_subtitle','p1.xcompany_desc','p2.xcompany_title as parentName','p1.xcompany_menu','p1.type','p1.xcompany_footer','p1.xstatus',DB::raw("CONCAT('/company/', p1.xcompanyid,'/', REPLACE(p1.xcompany_title,' ','-')) as link")]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('p1.xcompanyid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "p1.xcompanyid",
                "direction" => "desc",
            ]];
        }
        $heading = ['عنوان','زیر عنوان','توضیحات','نام والد','قرارگیری در منو','نوع','قرارگیری در فوتر','وضعیت','لینک'];
        return (new Export($this->list,$heading))->download('companys.xlsx');
    }

}