<?php namespace Modules\Tracking\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Tracking\Models\Group;
use Modules\Tracking\Models\Acquaint;
use DB;

class AcquaintController extends BackendController {

    public $title = "acquaint";
    
    function __construct(){
        $this->model = Acquaint::query();
        parent::__construct();
    }

    protected $scaffold = [
        'checkbox' => true,
        'footerSum' => false
    ];

    protected  $fields = [

        'name' => [
            'name' => 'name',
            'listView' => true,
            'searchView' => true,
            'text' => 'عنوان',
            'orderable' => true,
            'type' => 'text',
        ],
        'description' => [
            'name' => 'description',
            'listView' => false,
            'searchView' => true,
            'text' => 'توضیحات',
            'type' => 'text'
        ],
        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => false,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '140',
        ],


    ];
    

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->values = Acquaint::find($id);
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $acquaint = Acquaint::updateById($frm, $id);
        return redirect()->back()->with('status', '1');
    }

    //## delete
    public function delete($id) {
        Acquaint::remove($id);
    }

    //## set combo
    public function setCombo() {
        
    }

    

}