<?php namespace Modules\Social\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Social\Models\Social;

use Config;
use Input;
use File;
use App;
use DB;

class SocialController extends BackendController {
    public $title = "social";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["xsocial_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xsocial_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xsocial_link"],25);', 'name' => @t('link'), 'css' => 'width: 10%', 'sortable' => 'xsocial_link');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
    
        $this->list = Social::getResult();
        $this->paginate(); 
        
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = Social::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = Social::updateById($frm,$id);
        $this->saveFile($id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        Social::remove($id);
        
    }

    //## delete Image
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        $this->layout->titleList = $this->layout->content->titleList = Social::fetchenum('xsocial_title');
    }

}