@section('content')
<div class="col-xs-12 editBook">
    <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="active">
            <a href="#home" aria-controls="home" role="tab" data-toggle="tab">اطلاعات عمومی</a>
        </li>
        <li role="presentation">
            <a href="#desc" aria-controls="desc" role="tab" data-toggle="tab">توضیحات</a>
        </li>
        <li role="presentation">
            <a href="#finance" aria-controls="finance" role="tab" data-toggle="tab">اطلاعات مالی</a>
        </li>
        <li role="presentation">
            <a href="#files" aria-controls="files" role="tab" data-toggle="tab">سئو</a>
        </li>
    </ul>
    <div class="tab-content">
        <div role="tabpanel" class="tab-pane active" id="home">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@lang('language.title'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[name]', @$list['name'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.subtitle'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[subname]', @$list['subname'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('part number'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[part_number]', @$list['part_number'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('category'):</td>
                    <td class="form-inline">
                        <div class="form-group w-100">
                            {!! Form::select('frm[group_id]',$groupList, @$list->group_id, ['class' => 'form-control sub-category w-100','style'=>'width:100%;','data-advancedselect' => 'select2'])  !!}
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('brand'):</td>
                    <td class="form-inline">
                        <div class="form-group w-100">
                            {!! Form::select('frm[brand_id]',$brandList, @$list->brand_id, ['class' => 'form-control  w-100','style'=>'width:100%;','data-advancedselect' => 'select2'])  !!}
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('model'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[model]', @$list['model'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                {{-- <tr>
                    <td>@t('other models'): </td>
                    <td>
                        {!! Form::select('models[]', @$modelList, @$list ? @$list->otherModel->pluck('model','model') : [], ['class' => 'form-control w-100','style'=>'width:100%;', 'data-advancedselect' => 'select2','data-tags' => 'true', 'multiple'=>"multiple"])  !!}
                        {!! Form::hidden('modelInput',null)!!}
                    </td>
                </tr> --}}

                <tr>
                    <td>@t('quantity'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[quantity]', @$list['quantity'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                        @if(@$list)
                            <a href="/Admin/Product/outStockNotify/{{$list->id}}" class="btn btn-danger" onclick="if(confirm('ایا از انتخاب خود اطمینان دارید ؟'))App.exportCall('/outStockNotify/{{$list->id}}')">ارسال موجودشدن کالا</a>
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>@t('warranty'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[warranty]', @$list['warranty'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('year'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[year]', @$list['year'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('sold count'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            {!! Form::text('frm[sold_count]', @$list['sold_count'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
              
                <tr>
                    <td class="frm-title">@t('type'):</td>
                    <td>
                        <div class="form-group">
                        {!! Form::text('frm[type]', @$list['type'], array('class' => 'form-control', ))  !!}
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('tags'): </td>
                    <td>
                        {!! Form::select('tags[]', @$tagList, @$list->tags, ['class' => 'form-control', 'data-advancedselect' => 'select2','data-tags' => 'true', 'multiple'=>"multiple"])  !!}
                        {!! Form::hidden('tagInput',null)!!}
                    </td>
                </tr>

                <tr>
                    <td>@t('sync'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                {!! Form::hidden('frm[sync]', 0)!!}
                               <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[sync]', 1, @$list['sync'],array('class'=>'no-checker'))  !!}
                                    <span class="el-switch-style"></span>
                                </label>
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('status'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                {!! Form::hidden('frm[xstatus]', 0)!!}
                               <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[xstatus]', 1, @$list['xstatus'],array('class'=>'no-checker'))  !!}
                                    <span class="el-switch-style"></span>
                                </label>
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                        <td>@t('reminder'):</td>
                        <td>
                            <div class="form-group">
                                <div class="input-icon">
                                    {!! Form::hidden('frm[reminder]', 0)!!}
                                <label class="el-switch el-switch-green">
                                    {!! Form::checkbox('frm[reminder]', 1, @$list['reminder'],array('class'=>'no-checker'))  !!}
                                        <span class="el-switch-style"></span>
                                    </label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    
                <tr>
                    <td>@lang('language.display rank'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('viewed'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[viewed]', @$list['viewed'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td colspan="2">
                        <table class="table table-striped">
                            <tr>
                                <th>@lang('language.picture'): </th>
                            </tr>
                            <tr>
                                <td>
                                    @include('admin.partial.fileInput', ['exist' => @$imgExist, 'src' => '/pic/product/' . @$list['id'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['id']])
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="desc">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                    <tr>
                            <td>@t('feature'):</td>
                            <td>
                                <div class="form-group">
                                    <div class="textarea">
        
                                    {!! Form::textarea('frm[feature]', @$list['feature'], array('class' => 'form-control tinymce_editor', ))  !!}
                                    </div>
                                </div>
                            </td>
                        </tr>
                <tr>
                    <td>@t('abstract'):</td>
                    <td>
                        <div class="form-group">
                            <div class="textarea">

                            {!! Form::textarea('frm[abstract]', @$list['abstract'], array('class' => 'form-control tinymce_editor', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
               <tr>
                    <td>@t('description'):</td>
                    <td>
                        <div class="form-group">
                            <div class="textarea">

                            {!! Form::textarea('frm[description]', @$list['description'], array('class' => 'form-control tinymce_editor' ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
               
            </table>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="finance">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@t('price') (@t('toman')) : </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[price]', @$list['price'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('discount') (@t('toman')) : </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[discount]', @$list['discount'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                
            </table>
            </div>
        </div>

         <div role="tabpanel" class="tab-pane" id="files">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
            <tr>
                    <td> @lang('language.link') @t('redirect'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[redirect_url]', @$list['redirect_url'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
            <tr>
                        <td>@t('seo title'):</td>
                        <td>
                            <div class="form-group">
                                <div class="input-icon">
                                    <i class="fa fa-user"></i>
                                    {!! Form::text('frm[seo_title]', @$list['seo_title'], array('class' => 'form-control'))  !!}
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>@t('seo description'):</td>
                        <td>
                            <div class="form-group">
                                <div class="input-icon">
                                    <i class="fa fa-user"></i>
                                    {!! Form::text('frm[seo_description]', @$list['seo_description'], array('class' => 'form-control'))  !!}
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td>@t('tag') @t('canonical'):</td>
                        <td>
                            <div class="form-group">
                                <div class="input-icon">
                                    <i class="fa fa-user"></i>
                                    {!! Form::text('frm[seo_canonical]', @$list['seo_canonical'], array('class' => 'form-control'))  !!}
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td>@t('tag') @t('noindex'):</td>
                        <td>
                            <div class="form-group">
                                <div class="input-icon">
                                    {!! Form::hidden('frm[seo_noindex]', 0)!!}
                                <label class="el-switch el-switch-green">
                                    {!! Form::checkbox('frm[seo_noindex]', 1, @$list['seo_noindex'],array('class'=>'no-checker'))  !!}
                                        <span class="el-switch-style"></span>
                                    </label>
                                </div>
                            </div>
                        </td>
                    </tr>

                   
                    </table>
            </div>
        </div>

    </div>

</div>
    
    <script type="text/javascript">
        var attachmentList = {!! (@$attachmentList) ? $attachmentList : "null" !!}
        Custom.fileUploaderInit({{Config('app.id')}},attachmentList);
    </script>
@stop