<?php namespace Modules\Shop\Models;

use DB;
use stdClass;
use App\Models\Model;

class ProductImage extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'shop_product_image';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    protected $guarded = ['id'];
    public $lang = false;

    protected $casts = [
        'product_id' => 'int',
        'xrank' => 'int',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

     /**
     * Get the book that owns the gallery.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();
        $res = DB::table($instance->table)
            ->select(array('*', $instance->primaryKey . ' AS xid'));

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     * @example ModelName::remove(5) | ModelName::remove("xusername = 'test'")
     */
    public static function remove($id)
    {
        $instance = new static();
        $cond = intval($id) != 0 ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}