<?php namespace Modules\Shop\Models;

use App;
use App\Models\Model;
use DB;
use Modules\Cart\Models\Invoice;
use Modules\Comment\Models\Comment;
use Modules\Festival\Models\Festival;
use Modules\Home\Models\Tag;
use Modules\Goldiran\Models\ProductModel;
use Modules\Goldiran\Traits\GS;
use Illuminate\Support\Carbon;

class Product extends Model {
    use GS;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'shop_product';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'group_id' => 'int',
        'price' => 'int',
        'discount' => 'int',
        'year' => 'int',
        'sold_count' => 'int',
        'quantity' => 'int',
        'type' => 'int',
        'xstatus' => 'int',
        'xrank' => 'int',
    ];

    protected $relation = [
       
    ];

    protected $hidden = array('pivot');

    /**
     * Get the gallery for the book.
     */
    public function images() {
        return $this->hasMany(ProductImage::class, 'product_id');
    }

    /**
     * Get the gallery for the book.
     */
    public function brand() {
        return $this->belongsTo(Brand::class, 'brand_id');
    }

     /**
     * Get the gallery for the book.
     */
    public function otherModel() {
        return $this->hasMany(ProductModel::class, 'product_id');
    }

    /**
     * Get all of the book's comments.
     */
    public function comments() {
        return $this->morphMany(Comment::class, 'xcommentable');
    }

    /**
     * Get the invoice for the book.
     */
    public function invoices() {
        return $this->belongsToMany(Invoice::class, 'xxshop_invoiceitem', 'id', 'xinvoiceid')->withPivot('xinvoiceitem_price', 'xinvoiceitem_discount', 'xinvoiceitem_quantity');
    }

    /**
     * Get the invoice for the book.
     */
    public function festival() {
        return $this->belongsToMany(Festival::class, 'xxfestival_item', 'product_id', 'xfestivalid')->withPivot('xdiscount');
    }

    /**
     * Get the category that owns the book.
     */
    public function group() {
        return $this->belongsTo(Group::class, 'group_id');
    }

    public function favorites() {
        return $this->belongsToMany(User::class, 'xxuser_favorite', 'id', 'xuserid');
    }

    public function tags() {
        return $this->morphToMany(Tag::class, 'taggable', 'xxtaggables', 'taggable_id', 'tag_id');
    }

    public function specifications(){
        return $this->hasMany(Specification::class, 'product_id')->orderBy('xrank','desc');
    }

    public function discountPrice(){
        $perProduct = $this->discount;
        $festival = $this->festival()->where('xstatus',1)->where('expaire_at','>=',Carbon::now())->orderBy('xrank','desc')->first();
        $festivalPrice = $festival ? $festival->pivot->xdiscount : 0;
        return $festivalPrice ? ['price' => $festivalPrice,'type' => 'festival', 'id' => $festival->xfestivalid] : ($perProduct ? ['price' => $perProduct, 'type' => 'perProduct'] : ['price' => 0, 'type' => 'none']);
    }

    public function getGSPrice(){
        $gsOutput = ((array)$this->gsPartBalance($this->part_number));
        if (!$gsOutput) {
            return null;
        }
        $array = (array)@$gsOutput['partInfo'];
        $array['customerPrice'] = $array['customerPrice']/10;
        if($this->quantity != $array["legalAvail"] || $this->price != $array["customerPrice"]){
            $this->quantity = $array["legalAvail"];
            $this->price = $array["customerPrice"];
            $this->save();
        }
        
        return $array; 
    }
    public function getFastGSPrice(){
        $array = [
            "partNo" => $this->part_number,
            "legalAvail" => $this->quantity,
            "customerPrice" => $this->price
        ];
        return $array;   

    }

    // public function getPriceAttribute($value)
    // {
    //     if(config('app.theme') == 'goldiran'){
    //         $data = $this->getGSPrice();
    //         return $data['customerPrice'];
    //    }else{
    //        return $value;
    //    }
    // }

    // public function getQuantityAttribute($value)
    // {
    //     if(config('app.theme') == 'goldiran'){
    //         $data = $this->getGSPrice();
    //         return $data['legalAvail'];
    //    }else{
    //        return $value;
    //    }
    // }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table ." AS p")
            ->leftJoin('shop_group as g', 'g.id', '=', 'p.group_id')
            ->select(['*', "p.{$instance->primaryKey} AS xid","p.name as productName","g.name AS groupName"]);

        return $res;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $images = $instance->find($id)->images;

            foreach ($images as $image) {
                parent::deleteFile($image->xbook_imageid, 'gallery');
                $image->delete();
            }

            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

    /**
     * Hire car models
     * @param $id
     * @return mixed
     */

    public static function subSelect() {
        $sql = "SELECT *
                    FROM (
                    SELECT xbookgroupid, GROUP_CONCAT( xbooksubgroupid,  ':', xbooksubgroup_title ) AS subselect
                    , GROUP_CONCAT( xbooksubgroupid,  ':', xbooksubgroup_title_en ) AS subselectEn
                    , GROUP_CONCAT( xbooksubgroupid,  ':', xbooksubgroup_title_ar ) AS subselectAr
                    FROM  `xxbooksubgroup`
                    GROUP BY xbookgroupid
                    )q1
                    LEFT JOIN xxbookgroup
                    USING ( xbookgroupid )
                    where xbookgroup_lang = '" . App::getLocale() . "'";
        $res = DB::select($sql);

        return $res;
    }

    public static function price($color) {
        if ($color) {
            return this;
        }

    }
}