<?php namespace Modules\Shop\Models;

use App\Models\Model;
use DB;

class Group extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'shop_group';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = [];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
        'parent_id' => 'int',
    ];

    /**
     * Get the category that owns the sub category.
     */
    public function parent() {
        return $this->belongsTo(Group::class, 'parent_id');
    }

    /**
     * Get the category that owns the sub category.
     */
    public function childs() {
        return $this->hasMany(Group::class, 'parent_id');
    }

    /**
     * Get the category that owns the book.
     */
    public function products() {
        return $this->hasMany(Product::class, 'group_id');
    }

    public function getAllChild(){
        return $this->select('shop_group.id')
            ->leftJoin('shop_group as p2','p2.id','shop_group.parent_id')
            ->leftJoin('shop_group as p3','p3.id','p2.parent_id')
            ->whereRaw(" {$this->id} in (shop_group.parent_id,p2.parent_id,p3.parent_id)")
            ->orderByRaw('1')
            ->get();
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . " AS g")
            ->leftJoin($instance->table . " AS gp","g.parent_id",'=',"gp.{$instance->primaryKey}")
            ->select(['g.*', "g.{$instance->primaryKey} AS xid","gp.name as parent"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        $cond = (int) $id ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}