<?php namespace Modules\Shop\Models;

use App\Models\Model;
use DB;
use Illuminate\Support\Carbon;
use Modules\Shop\Models\Group;

class Copoun extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'shop_copoun';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'xsubcategoryid' => 'int',
        'discount' => 'int',
        'max_discount' => 'int',
        'expires_at' => 'j2timestamp',
        'xrank' => 'int',
    ];

    /**
     * Get the book for the cart.
     */
    public function group()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table("$instance->table")
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

    public static function findByCode($code)
    {
        $instance = new static();
        return $instance->where('code', $code)->first();
    }

    public function discountPrice($total)
    {
        if ($this->type == 'flat') {
            return $this->discount;
        } elseif ($this->type == 'percent') {
            return round(((int)$this->discount / 100) * $total);
        } else {
            return 0;
        }
    }

    public function limitation($total, $products)
    {
        if ($this->expires_at < Carbon::now()) {
            return false;
        }

        //if ($this->min_buy > $total)
        //  return false;
        if ($this->status != 1) {
            return false;
        }
        if ($this->used_count < 1) {
            return false;
        }
        
        if ($this->group_id){
            $categories = Product::whereIn('id',$products)->select('group_id')->distinct()->get();
            
            foreach ($categories as $cat) {
                if ($this->group_id != $cat->group_id)
                    return false;
            }
        }
        $discount = $this->discountPrice($total);

        if ($this->max_discount < $discount) {
            return $this->max_discount;
        }

        return $discount;
    }
}
