<?php namespace Modules\Shop\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use Modules\Advertise\Models\Advertise;
use Modules\Shop\Models\Product;
use Modules\Shop\Models\ShopQuery;
use Modules\Shop\Models\Group;
use Modules\Shop\Models\Brand;
use Modules\Home\Models\Banner;
use Modules\Home\Models\Tag;
use Modules\Blog\Models\Article;
use Modules\Page\Models\PageWidget;
use Input;
use Request;

class ShopController extends IndexController
{

  
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    //protected $layout = 'index.goldiran.amp-blank-layout';
    //protected $layout = 'index.goldiran.react-blank-layout';

    public function index()
    {
        
        $orderby = 'desc';

        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->getWithLocale();


        $advertise = Advertise::leftJoin('xxadvertise_place', function ($join) {
            $join->on('xxadvertise.xplaceid', '=', 'xxadvertise_place.xplaceid');
        })->where('xlocation', 'Home')
            ->orderBy('xxadvertise_place.xrank', 'desc')
            ->orderBy('xxadvertise.xrank', 'desc')
            ->get();

        

        $banners = Banner::where('xstatus', '1')->getWithLocale();
        $pagewidgets = PageWidget::with('widgets.items')->where('page_id',15)->orderBy('xrank','asc')->getWithStatus();
        
        $this->layout->content = view(
            'shop::index.home',
            [
                'orderby' => $orderby,
                'banners' => $banners,
                'lastArticles' => $lastArticles,
                'advertise' => $advertise,
                'pagewidgets' => $pagewidgets,
            ]
        );
    }

    public function search(){
        $str = Input::get('src');

        $title = "search result";
        $text = 'what can we help you with?';

        $this->layout->pagetitle = ['title' => $title, 'text' => $text];

        $items = Product::where('xstatus', 1)
            ->where(function($q) use ($str){
                $q->where('name', 'like', "%{$str}%")
                ->orWhereIn('id',function($query) use ($str){
                    $query->select('taggable_id')
                        ->from('xxtaggables')
                        ->where('taggable_type','Modules\Shop\Models\Product')
                        ->whereIn('tag_id',function($query) use ($str){
                            $query->select('xtagid')
                                ->from('xxtags')
                                ->where('xname','like',"%{$str}%");
                        });
                });
            })
            ->orderBy('xrank', 'desc');

        $items = $items->paginate(30)->withPath(Request::url());
        $brands = Brand::all();

        $this->layout->content = view('shop::index.group', [
            'products' => $items,
            'brands' => $brands,
            'type' => 'product',
            'id' => 0,
            'name' => 'نتایج جستجو'
        ]);

        //$breadcrumb[] = ['title' => t($title), 'href' => ''];
        //$this->layout->content->breadcrumb = $breadcrumb;
    }
}
