<?php namespace Modules\Shop\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use App\Traits\UploadMultiFile;
use Auth;
use Input;
use Modules\Shop\Models\Product;
use Modules\Shop\Models\ProductImage;
use Modules\Shop\Models\ShopQuery;
use Modules\Shop\Models\Group;
use Modules\Shop\Models\Brand;
use Modules\Home\Models\Tag;
use Modules\Goldiran\Traits\GS;
use Redirect;
use Request;
use Str;
use Modules\Shop\Models\OutStockNotify;

class ProductController extends IndexController
{
    use GS;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */
    //protected $layout = 'index.goldiran.amp-blank-layout';

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index()
    {
        $sort = 'xproduct_rank';
        $orderby = 'desc';
        $cat = Group::get();

        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;

        $this->layout->title = t('book');
        $this->layout->content = view('book::index.widget.categoryList', [
            'list' => $cat,
            'title' => 'دسته بندی کتب',
        ]);
    }

    const SORT_CONST = [
        0 => ['quantity','DESC'],
        1 => ['price','DESC'],
        2 => ['price','ASC'],
        3 => ['viewed','DESC'],
        4 => ['created_at','DESC'],
        5 => ['sold_count','DESC'],
    ];

    public function group($id, $title= null){
        $title = str_replace(' ','-', $title);
        return redirect('/shop/main/'.$title,301);
    }
    public function getCategoryModels(){
        $code = Input::get('code');
        $models= [];
        
        foreach (explode(',',@$code) as $key => $value) {
            if($value)
                $models = array_merge((array)(@$this->gsGetModelByProductCode($value)->string),$models);
        }
        
        return response()->json(['items' => $models])->header('access-control-allow-headers', 'Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token')
        ->header('access-control-allow-credentials', 'true')
        ->header('access-control-allow-origin', '*') 
        ->header('access-control-allow-methods', 'POST, GET, OPTIONS'); 
        
    }
    public function category($id, $title = null)
    {
        $price = Input::get('price');
        $selectedBrand = Input::get('brand');
        $modelName = Input::get('modelName');
        $onlyAvaliable = Input::get('onlyAvailable');
        $sort = Input::get('sortby');
        $sortContent = self::SORT_CONST[$sort ?? 5];
        
        if ($id){
            $group = Group::find($id);
            $gids = $group->getAllChild();
        }

        $products = Product::whereIn('group_id', array_merge($gids->toArray(),[$id]))->where('xstatus',1)
            ->when($price['min'], function ($query, $data) {
                return $query->where('price', '>=', $data);
            })->when($price['max'], function ($query, $data) {
                return $query->where('price', '<=', $data);
            })->when($selectedBrand, function ($query, $data) {
                return $query->whereIn('brand_id', $data);
            })->when($modelName, function ($query, $data) {
                return $query
                    ->join('goldiran_product_model','goldiran_product_model.product_id','=','shop_product.id')
                    ->where('goldiran_product_model.model', 'regexp', str_replace(' ','|',$data))
                    ->orWhere('shop_product.model', 'regexp', str_replace(' ','|',$data));
            })->when($onlyAvaliable, function ($query) {
                return $query->where('quantity', '>', 0);
            })
            ->groupBy('shop_product.id')
            ->orderBy(\DB::raw("IF(shop_product.quantity > 0, 1, 0)"), 'DESC')
            ->orderBy('shop_product.'.$sortContent[0], $sortContent[1])
            ->get();
       
        
        // $models= [];
        // foreach (explode(',',@$group->meta) as $key => $value) {
        //     if($value)
        //         $models = array_merge((array)(@$this->gsGetModelByProductCode($value)->string),$models);
        // }
        
        
        $breadcrumb[] = ['title' => t('products'), 'href' => ''];
        if ($group) {
            if ($group->parent)
                $breadcrumb[] = ['title' => $group->parent->name, 'href' => ''];
            $breadcrumb[] = ['title' => $group->name, 'href' => ''];

            $path = dirname(\View::getFinder()->find('shop::index.group.index'));
            $widgetConfig = json_decode(file_get_contents($path . '/config.json'),true);
            $this->layout->widgetConfig = $widgetConfig;

            $pathToAccess = $this->getParent($group, true);
            $filters = json_decode($group->filters,true);
            $assignFilters = [];
            $userFilter = Input::all();
            foreach ($filters['items']['values'] ?? [] as $key => $filter) {
                if(@$filter['values']){
                    foreach ($filter['values'] as $keyItem => $item) {
                        if(@$userFilter[$filter['name']] && in_array($item['id'],$userFilter[$filter['name']])){
                            $filters['items']['values'][$key]['values'][$keyItem]['value'] = true;
                            $assignFilters[] = ['name' => $filter['name'], 'title' => $item['title'], 'value' => $item['id']];
                        }else{
                            $filters['items']['values'][$key]['values'][$keyItem]['value'] = false;
                        }
                    }
                }elseif(@$filter['price']){
                    if(@$userFilter[$filter['name']]){
                        $title = $filter['title'] . ' از ' . number_format($userFilter[$filter['name']]['min']) . ' تا ' . number_format($userFilter[$filter['name']]['max']);
                        $assignFilters[] = ['name' => $filter['name'], 'title' => $title , 'value' => $filter['id']];
                        $filters['items']['values'][$key]['minValue'] = $userFilter[$filter['name']]['min'];
                        $filters['items']['values'][$key]['maxValue'] = $userFilter[$filter['name']]['max'];
                    }
                }elseif(@$filter['switch']){
                    if(@$userFilter[$filter['name']]){
                        $assignFilters[] = ['name' => $filter['name'], 'title' => $filter['title'], 'value' => '1'];
                        $filters['items']['values'][$key]['value'] = true;
                    }else{
                        $filters['items']['values'][$key]['value'] = false;
                    }
                }elseif(@$filter['autoComplete'] || @$filter['text']){
                    if(@$userFilter[$filter['name']]){
                        $assignFilters[] = ['name' => $filter['name'], 'title' => $filter['title'].' '.$userFilter[$filter['name']], 'value' => $userFilter[$filter['name']]];
                        $filters['items']['values'][$key]['value'] = $userFilter[$filter['name']];
                    }
                }
            }
           
            $this->layout->title = $group->seo_title ?? ($group->name ?? '');
            $this->layout->canonical = $group->seo_canonical;
            $this->layout->seoNoIndex = $group->seo_noindex;
            $this->layout->description = $group->seo_description;
        }

        $this->layout->content = view('shop::index.group.index', [
            'assignFilters' => $assignFilters,
            'sort' => $sort ?? 5,
            'products' => $products,
            'pathToAccess' => $pathToAccess,
            'name' => $group ? $group->name : 'محصولات',
            'changed_filters' => $filters,
            'id' => $group ? $group->id : 0,
            //'models' => $models,
            'code' => @$group->meta,
            'hideUnavailable' => $onlyAvaliable
        ]);
        //$this->layout->content->breadcrumb = $breadcrumb;
    }

    public function getParent($group,$withSibling = false){
        $node = $group;
        $parents = [['id' => $node->id, 'name' => $node->name, 'url' => '/product/category/'.$node->id. '/' . $node->name, 'childs' => null]];
        if($withSibling){
            $siblings = $this->getSibling($group)->toArray();
            $parents = array_merge($parents,$siblings);
        }

        while($node->parent_id != 0){
            $node = $node->parent;
            $temp = $parents;
            $parents =[['id' => $node->id, 'name' => $node->name, 'url' => '/'.App::getLocale().'/product/group/'.$node->id. '/' . $node->name, 'childs' => $temp]];
        }

        return $parents;
    }
    public function getSibling($group){
        $parent = $group->parent;
        $parentId = $parent ? $parent->id : 0;
        $groups = Group::where('parent_id',$parentId)
            ->where('id','<>',$group->id)
            ->where('xstatus',1)
            ->select('id','name',\DB::raw('null as childs'))
            ->get();
        
        return $groups;
    }

    public function query($id)
    {
        $query = ShopQuery::find($id);
        if ($query) {
            $products = Product::with(['group','festival'])->where('xstatus', 1)->orderBy('xrank', 'desc')
                ->when($query['group_id'], function ($query, $data) {
                    return $query->whereIn('group_id', explode(',', $data));
                })
                ->when($query['xtagid'], function ($query, $data) {
                    $tag = Tag::find($data);
                    return $query->whereIn('id', $tag->products->pluck('id'));
                })
                ->when($query['sortby'], function ($query, $data) {
                    return $query->orderBy($data, 'desc');
                });
        }

        $breadcrumb[] = ['title' => t('product'), 'href' => ''];
        $breadcrumb[] = ['title' => $query->name, 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title = t('book');
        $products = $products->paginate(30)->withPath(Request::url());
        $this->layout->content = view('book::index.bookList', [
            'books' => $products,
            'title' => $query->name,
        ]);
    }

    public function detail($id, $title = null)
    {
        $product = Product::where('id',$id)->where('xstatus',1)->first();
        if(!$product)
            return redirect('/shop');
        
        if($product->redirect_url)  return redirect($product->redirect_url,301);

        $gallery = ProductImage::where('product_id', $id)->get();
        //dd($product->specifications);
        $relatedProduct = Product::where('group_id', $product->group_id)
            ->where('xstatus', 1)
            ->orderBy('sold_count', 'desc')
            ->orderBy('xrank', 'desc')
            ->take(7)
            ->get();
        
        $comments = $product->comments()
            ->where('xcomment_approved', 1)
            ->where('xparentid',0)
            ->orderBy('xparentid','asc')
            ->orderBy('xcomment_date','desc')
            ->get();

        $pathToAccess = $this->getParent($product->group, false);
        $breadcrumb = $pathToAccess;
       
       // $breadcrumb[] = ['title' => $product->name, 'href' => ''];
        
        $this->layout->title = $product->seo_title ?? ($product->name ?? '');
        $this->layout->canonical = $product->seo_canonical;
        $this->layout->seoNoIndex = $product->seo_noindex;
        $this->layout->description = $product->seo_description;        
        $this->layout->footerOff = false;

        $this->layout->title2 = $product->name;
        $this->layout->description = Str::words($product->abstract, 40);
        $this->layout->ogImage = '/pic/product/' . $product->id . 'w135h200c1/' . $product->id . '.jpg';

        $path = dirname(\View::getFinder()->find('shop::index.detail'));
        $widgetConfig = json_decode(file_get_contents($path . '/config.json'),true);
        $this->layout->widgetConfig = $widgetConfig;
        $this->layout->content = view('shop::index.detail', [
            'product' => $product,
            'gallery' => $gallery,
            'relatedProduct' => $relatedProduct,
            'comments' => $comments,
            'shopbreadcrumb' => $breadcrumb,
        ]);
    }

    public function pressureTest(){
        $this->layout->content = view('shop::index.pressureTest');
    }

    public function pressureTestRun(){
        $id = Input::get('productId') ?? 2112;
        $count = Input::get('count') ?? 10;
        $time = Input::get('time') ?? 0.25;
        $result = [];
       
        $product = Product::where('id',$id)->where('xstatus',1)->first();
        if(!$product)
            return \Redirect::back()->with([ 'message' => 'محصول یافت نشد']);

        for ($j =0; $j < 1; $j++){
            $spease = [];
            for ($i=0; $i < $count; $i++) {     
                $price = $product->getGSPrice();
                $spease[] =json_encode($price);
                sleep($time);
            }
            dd($spease);
            $result[$j]['correct'] = 0;
            $result[$j]['notCorrect'] = 0;
            
            foreach ($spease as $key => $value) {
                if($value && $value != "null"){
                    $result[$j]['correct'] ++;
                }else{
                    $result[$j]['notCorrect'] ++;
                }
            }

            $result[$j]['percentage'] = ($result[$j]['notCorrect'] / $count) * 100;
        }
        
        dd($result);
        return \Redirect::back()->with([ 'message' => $result]);
        
    }

    public function addOutStockProduct()
    {
        $id = Input::get('id');
        $mobile = Input::get('mobile');
        $email = Input::get('email');
        $notification = Input::get('notification');
        $user = Auth::user();

        if (!$user) {
            return response()->json(['success' => false, 'message' => 'لطفا در سیستم وارد شوید', 'type' => 0], 401);
        }

        $result = OutStockNotify::where('product_id',$id)->where('user_id',$user->xuserid)->first();
        $state = $mobile == "true"? 100 : 0;
        $state = $email == "true"? $state+10 : $state;
        $state = $notification == "true" ? $state+1 : $state;
        $state = str_pad($state, 3, '0', STR_PAD_LEFT);
       
        if($result){
            $result->state = $state;
            $result->save();
        }else{
            OutStockNotify::updateById(['product_id'=>$id, 'user_id'=>$user->xuserid, 'state' => $state]);
        }
        return response()->json(['success' => true, 'message' => 'درخواست شما با موفقیت در سیستم ثبت شد.', 'type' => 100]);
    }

}
