<?php namespace Modules\Shop\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Input;
use Modules\Author\Models\Author;
use Modules\Shop\Models\ShopQuery;
use Modules\Shop\Models\Group;
use Modules\Shop\Models\SubCategory;
use Modules\Home\Models\Tag;
use Modules\Publisher\Models\Publisher;

class ShopQueryController extends BackendController {
    public $title = "shop query";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
    //FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)
    //FarsiLib::j2gDate() convert input from form
    public function index() {

        $this->field[] = array('php' => 'echo $item["sq_name"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'sq_name');
        $this->field[] = array('php' => 'echo $item["group_name"] ?? "همه گروه ها";', 'name' => @t('group'), 'css' => 'width: 10%');
        $this->field[] = array('php' => 'echo t($item["sortby"]);', 'name' => @t('sort'), 'css' => 'width: 10%', 'sortable' => 'sortby');
        $this->field[] = array('php' => 'echo $item["count"];', 'name' => @t('count'), 'css' => 'width: 10%', 'sortable' => 'count');
        $this->field[] = array('php' => 'echo $item["query_rank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'SQ.xrank');

        $this->list = ShopQuery::getResult();

        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = ShopQuery::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $frm['groups_id'] = @$frm['groups_id'] ? implode(',', $frm['groups_id']) : null;
        $book = ShopQuery::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        ShopQuery::remove($id);

    }

    //## set combo
    public function setCombo() {
        $this->layout->tagList = $this->layout->content->tagList = Tag::pluck('xname', 'xtagid')->prepend('', '');
        $this->layout->groupList = $this->layout->content->groupList = Group::pluck('name', 'id')->prepend('', '');
        $this->layout->sortList = $this->layout->content->sortList = [
            'xrank' => 'اولویت',
            'sold_count' => 'پرفروش ترین',
            'created_at' => 'جدیدترین',
        ];
    }

}