<?php namespace Modules\Shop\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use DB;
use Modules\Shop\Models\Copoun;
use Modules\Shop\Models\Group;

class ShopCopounController extends BackendController {
    public $title = "copoun";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["name"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] = array('php' => 'echo $item["code"]?:"بدون والد";', 'name' => @t('code'), 'css' => 'width: 10%', 'sortable' => 'code');
        $this->field[] = array('php' => 'echo $item["discount"];', 'name' => @t('discount'), 'css' => 'width: 10%', 'sortable' => 'discount');
        $this->field[] = array('php' => 'echo $item["used_count"];', 'name' => @t('count'), 'css' => 'width: 10%', 'sortable' => 'used_count');
        $this->field[] = array('php' => 'echo htmlStatus($item["xstatus"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%');

        $this->list = Copoun::getResult();
        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Copoun::find($id);
        $this->layout->title = $this->title;

    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $book = Copoun::updateById($frm, $id);

        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Copoun::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        $this->layout->GroupList = $this->layout->content->GroupList = [1];
        $this->layout->SubGroupList = $this->layout->content->SubGroupList = [1];
        $this->layout->groupList = $this->layout->content->groupList = Group::join('shop_group as g2','g2.id','=','shop_group.parent_id')
            ->select(DB::raw("CONCAT(g2.name,'-',shop_group.name) as parentname"), 'shop_group.id')    
            ->pluck('parentname','id')
            ->prepend('', '');
        
    }

}