<?php namespace Modules\Shop\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Traits\UploadMultiFile;
use Auth;
use Carbon\Carbon;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Shop\Models\Product;
use Modules\Shop\Models\ProductImage;
use Modules\Shop\Models\Group;
use Modules\Shop\Models\Brand;
use Modules\Shop\Models\OutStockNotify;
use Modules\Home\Models\Tag;
use Modules\Goldiran\Models\ProductModel;
use DB;
use Modules\Shop\Models\Specification;
use SMS;

class ProductController extends BackendController {
    use UploadMultiFile;

    public $title = "product";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/product/\' . $item["xid"] . "w100h110c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] = array('php' => 'echo $item["productName"];', 'name' => @t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] = array('php' => 'echo $item["groupName"];', 'name' => @t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] = array('php' => 'echo $item["quantity"];', 'name' => @t('quantity'), 'css' => 'width: 10%', 'sortable' => 'quantity');
        $this->field[] = array('php' => 'echo $item["sold_count"];', 'name' => @t('sold count'), 'css' => 'width: 10%', 'sortable' => 'sold_count');
        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = Product::getResult();

        $this->paginate();
        $this->layout->content->listBtn['showProductGallery'] = true;
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
        $this->layout->content->listBtn['showSpecification'] = true;
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Product::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
        //$this->layout->content->attachmentList = json_encode(self::attachmentFiles($id));
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        if(!$frm['group_id'])
            die('گروه کالا به درستی انتخاب نشده است');
        $tags = Input::get('tags');
        $newTags = Input::get('tagInput');
        //$models = Input::get('models');
        $newModels = Input::get('modelInput');
        $filesList = Input::get('filesUpload', []);
        $user = Auth::user();
        
        $product = Product::updateById($frm, $id);
        

        // $product->otherModel()->delete();
        // if($models)
        //     foreach ($models as $key => $value) {
        //         $product->otherModel()->create(['model'=>$value, 'xrank'=>0]);
        //     }
        
        
        $product->tags()->detach();
        $newTags = explode(',,', $newTags);
        if ($tags) {
            foreach ($tags as $key => $value) {
                if (!in_array($value, $newTags)) {
                    $product->tags()->attach($value);
                } else {
                    $product->tags()->create(['xname' => $value]);
                }

            }
        }

        //self::storeAttachmentFiles($product->id, $filesList);
        $this->saveFile($product->id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Product::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        //dd(Group::leftJoin('shop_group as g2','g2.id','=','shop_group.parent_id')->select(DB::raw('g2.name as kk'), 'shop_group.id')->get());
        $this->layout->groupList = $this->layout->content->groupList = Group::where('xstatus',1)
        //Group::leftJoin('shop_group as g2','g2.id','=','shop_group.parent_id')
          //  ->select(DB::raw("CONCAT(g2.name,'-',shop_group.name) as parentname"), 'shop_group.id')    
            ->pluck('name','id')
            ->prepend('', '');
        $this->layout->brandList = $this->layout->content->brandList = Brand::pluck('name','id')->prepend('', '');
        $this->layout->tagList = $this->layout->content->tagList = Tag::pluck('xname', 'xtagid');
        $this->layout->modelList = $this->layout->content->modelList = ProductModel::groupBy('model')->pluck('model','model');
        
    }

    public function editProductGallery($id) {
        $this->layout->storeMethod = 'storeProductGallery';
        $this->layout->content = view('shop::admin.edit.productImage');

        $galleryList = Product::find($id)->images->toArray();

        $this->layout->content->galleryList = $galleryList ?: [1];
        $this->layout->content->imageExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        foreach ($galleryList as $gallery) {
            $this->layout->content->galleryExist[$gallery['id']] = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/gallery/" . $gallery['id']);
        }
        $this->layout->title = '';
    }

    public function storeProductGallery($id) {
        $frm = Input::get('frm');
        $galleryList = Input::get('galleryList');
        $galleryImg = [];
        if ($galleryList) {
            foreach ($galleryList as $key => $gallery) {
                $gallery['product_id'] = $id;
                $gallery = ProductImage::updateById($gallery, $gallery['id']);
                $galleryImg[$key] = $gallery->id;
            }
        }
        $this->saveFile($id, $galleryImg);

        die('[[OK]]');
    }

    public function deleteProductGallery($id) {
        if ($id) {
            $res = ProductImage::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                File::delete(Config::get('upload.' . Config::get('app.controller')) . "/gallery/$id");
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }

    public function editSpecification($id){
        $this->layout->storeMethod = 'storeSpecification';
        $this->layout->content = view('shop::admin.edit.productSpecification');

        $product = Product::find($id);
        $this->layout->content->product = $product ?: [1];
        $this->layout->title = 'specification';
    }

    public function storeSpecification($id) {
        $list = Input::get('list');
        if ($list) {
            foreach ($list as $key => $value) {
                $value['product_id'] = $id;
                $value = Specification::updateById($value, $value['id']);
            }
        }
        die('[[OK]]');
    }

    public function deleteSpecification($id) {
        if ($id) {
            $res = Specification::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }

    public function outStockNotify($id){
        $FLAG_SMS = 100;
        if ($id){
            $products = OutStockNotify::with('user')->where('product_id',$id)->get();
            $product = Product::find($id);
            $msg = 'کالای '. $product->name . ' در سایت موجود شد ';

            foreach($products as $product){
                $user = $product->user;
                if($product->state & $FLAG_SMS){
                    $smsResponse = SMS::send($msg, $user->userInfo->xmobile, null,'outStockNotify');
                }
            }
        }
        die('[[OK]]');
    }


    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Product::getResult()->select(["p.name",'p.subname','p.part_number','g.name as groupName','p.brand_id','p.description','p.abstract','p.price','p.discount','p.year','p.sold_count','p.model','p.feature','created_at']);
        if (!$checkall && $listchk) {
            $this->list->whereIn('p.id', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "p.id",
                "direction" => "desc",
            ]];
        }
        $heading = ['عنوان','زیر عنوان','شماره قطعه','نام گروه','برند','توضیحات','چکیده','قیمت','تخفیف','سال تولید','تعداد فروخته شده','مدل','ویژگی ها','تاریخ ایجاد'];
        return (new Export($this->list,$heading))->download('products.xlsx');
    }

}