<?php namespace Modules\Shop\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Shop\Models\Brand;

use Config;
use Input;
use File;
use App;
use DB;

class BrandController extends BackendController {
    public $title = "brand";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' =>  @t('name'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["description"];', 'name' =>  @t('description'), 'css' => 'width: 10%');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = Brand::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having);
            
        $this->paginate();        
        
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = Brand::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $brand = Brand::updateById($frm,$id);
        $this->saveFile($brand->id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        Brand::remove($id);
    }

    //## delete Image
    public function deleteImage($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
    
    }

}