<?php namespace Modules\SMS\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\SMS\Models\SMS;

use Config;
use Input;
use File;
use App;
use DB;

class SMSController extends BackendController {
    public $title = "sms";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/sms/\' . $item["xsmsid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xsms_name"];', 'name' =>  @t('name'), 'css' => 'width: 10%', 'sortable' => 'xsms_name');
        $this->field[] =  array('php' => 'echo $item["xsms_desc"];', 'name' =>  @t('description'), 'css' => 'width: 10%');
 
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = SMS::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having);
            

        $this->paginate();        
        
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = SMS::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = SMS::updateById($frm,$id);
        $this->saveFile($id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        SMS::remove($id);
        
    }

    //## delete Image
    public function deleteImage($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
    
         $this->layout->GroupList = $this->layout->content->GroupList = [1];
         $this->layout->SubGroupList  = $this->layout->content->SubGroupList  = [1];
    }

}