<?php

namespace Modules\SMS\Factories;

use Exception;
use Modules\SMS\Search\Plivo;
use Modules\SMS\Search\Twilio;
use Modules\SMS\Search\Bandwidth;

class SearchFactory
{

    /**
     * Creates a driver instance
     * @param  string $driver The driver name to create a search instance for
     * @return \Modules\SMS\Search\Search
     */
    public function get($driver, $options)
    {
        return $this->{$driver}($options);
    }

    /**
     * Plivo
     * @param  array $options An array of search values for finding a phone number
     * @return \Modules\SMS\Search\Plivo
     */
    protected function plivo(array $options)
    {
        return new Plivo($options);
    }

    /**
     * Twilio
     * @param  array $options An array of search values for finding a phone number
     * @return \Modules\SMS\Search\Twilio
     */
    protected function twilio(array $options)
    {
        return new Twilio($options);
    }

    /**
     * Bandwidth
     * @param  array $options An array of search values for finding a phone number
     * @return \Modules\SMS\Search\Bandwidth
     */
    protected function bandwidth(array $options)
    {
        return new Bandwidth($options);
    }

     /**
     * Bandwidth
     * @param  array $options An array of search values for finding a phone number
     * @return \Modules\SMS\Search\Bandwidth
     */
    protected function sornasms(array $options)
    {
        return new Sornasms($options);
    }
}
