<?php

namespace Modules\SMS\Factories;

use Exception;
use Modules\SMS\Drivers\Asanak;
use Modules\SMS\Drivers\Plivo;
use Modules\SMS\Drivers\Twilio;
use Modules\SMS\Drivers\Bandwidth;
use Modules\SMS\Drivers\Sornasms;
use Modules\SMS\Drivers\Kavenegar;
use Modules\SMS\Drivers\Magfa;

class DriverFactory
{

    /**
     * Creates a driver instance
     * @param  string $driver The driver instance to create
     * @return \LeadThread\Sms\Drivers\SendsSms
     */
    public function get($driver)
    {
        $config = config("sms.{$driver}");
        if (is_array($config)) {
            return $this->{$driver}($config);
        } else {
            throw new Exception("config must be an array! You may have chosen an unsupported SMS driver.");
        }
    }

    /**
     * Plivo
     * @param  array $config An array of config values for setting up the driver
     * @return \LeadThread\Sms\Drivers\Plivo\Request
     */
    protected function plivo(array $config)
    {
        return new Plivo($config['user'], $config['token']);
    }

    /**
     * Twilio
     * @param  array $config An array of config values for setting up the driver
     * @return \LeadThread\Sms\Drivers\Twilio
     */
    protected function twilio(array $config)
    {
        return new Twilio($config['user'], $config['token']);
    }

    /**
     * Bandwidth
     * @param  array $config An array of config values for setting up the driver
     * @return \LeadThread\Sms\Drivers\Bandwidth
     */
    protected function bandwidth(array $config)
    {
        return new Bandwidth($config['secret'], $config['token'], $config['user_id']);
    }

    /**
     * sornasms
     * @param  array $config An array of config values for setting up the driver
     * @return \LeadThread\Sms\Drivers\Bandwidth
     */
    protected function sornasms(array $config)
    {
        return new Sornasms($config['portalCode'], $config['user'], $config['pass']);
    }

    /**
     * kavenegar
     * @param  array $config An array of config values for setting up the driver
     * @return \LeadThread\Sms\Drivers\Bandwidth
     */
    protected function kavenegar(array $config)
    {
        return new Kavenegar($config['api']);
    }

     /**
     * Magfa
     * @param  array $config An array of config values for setting up the driver
     * @return \LeadThread\Sms\Drivers\Bandwidth
     */
    protected function Magfa(array $config)
    {
        return new Magfa($config['domin'], $config['user'], $config['pass'], $config['sendernumber']);
    }

    protected function Asanak(array $config)
    {
        return new Asanak($config['user'], $config['pass'], $config['sendernumber']);
    }
}