<?php

namespace Modules\SMS\Drivers;


use Modules\SMS\Drivers\Driver;
use Modules\SMS\Interfaces\PhoneSearchParams;
use Modules\SMS\Responses\Sorenasms as SorenasmsResponse;
use SoapClient;

class Sornasms extends Driver
{

    protected $handle;
    protected $certificate;

    public function __construct($postal_code, $user, $pass)
    {
        $this->handle = new SoapClient("http://www.sornasms.net/webpublish2/sornaservice.asmx?wsdl");

        $this->certificate = [
            'PortalCode'  => $postal_code,
            'UserName'  => $user,
            'PassWord' => $pass,
        ];
    }

    public function send($msg, $to, $from, $lookup, $callback = null)
    {
        if (!empty($callback)) {
            throw new \Exception("Callback URLs are not implemented for Plivo", 1);
        }

        if ($lookup == 'sendOtp')
            $msg = $this->config['sms']['forgenCodeSMS'] ? str_replace('{code}', $msg, $this->config['sms']['forgenCodeSMS']) : null;
        elseif ($lookup == 'wellcome')
            $msg = $this->config['sms']['registerSMS'];
        elseif ($lookup == 'invoiceSuccess')
            $msg = $this->config['sms']['acceptBuySMS'] ? str_replace('{refCode}', $msg[0], $this->config['sms']['acceptBuySMS']) : null;

        if (!$msg)
            return;

        $params = [
            'Mobile' => $to,
            'Message' => $msg
        ];
        $params = array_merge($this->certificate, $params);

        return new SorenasmsResponse($this->handle->SingleSMSEngine($params));
    }

    public function searchNumber(PhoneSearchParams $search)
    {
        return new PlivoResponse($this->handle->search_phone_numbers($search->toArray()));
    }

    public function buyNumber($phone)
    {
        $params = [
            'number' => $phone
        ];

        return new PlivoResponse($this->handle->buy_phone_number($params));
    }

    public function sellNumber($phone)
    {
        $phone = str_replace("+", "", $phone);
        $params = [
            'number' => $phone
        ];
        return new PlivoResponse($this->handle->unrent_number($params));
    }
}
